/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.sql.Identifiers;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class AliasSymbol
implements Symbol {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(AliasSymbol.class);
    private final String alias;
    private final Symbol symbol;

    public AliasSymbol(String alias, Symbol symbol) {
        this.alias = alias;
        this.symbol = symbol;
    }

    public AliasSymbol(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.symbol = Symbol.fromStream(in);
    }

    public Symbol symbol() {
        return this.symbol;
    }

    public String alias() {
        return this.alias;
    }

    @Override
    public boolean isDeterministic() {
        return this.symbol.isDeterministic();
    }

    @Override
    public boolean any(Predicate<? super Symbol> predicate) {
        return predicate.test(this) || this.symbol.any(predicate);
    }

    @Override
    public ColumnIdent toColumn() {
        return ColumnIdent.of(this.alias);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias);
        Symbol.toStream(this.symbol, out);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.ALIAS;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitAlias(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.symbol.valueType();
    }

    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        return this.symbol.toString(style) + " AS " + Identifiers.quoteIfNeeded((String)this.alias);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.symbol.ramBytesUsed() + RamUsageEstimator.sizeOf((String)this.alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasSymbol that = (AliasSymbol)o;
        if (!this.alias.equals(that.alias)) {
            return false;
        }
        return this.symbol.equals(that.symbol);
    }

    public int hashCode() {
        int result = this.alias.hashCode();
        result = 31 * result + this.symbol.hashCode();
        return result;
    }
}

