/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class ScopedSymbol
implements Symbol {
    private final RelationName relation;
    private final ColumnIdent column;
    private final DataType<?> dataType;
    private final int identity;

    public ScopedSymbol(RelationName relation, ColumnIdent column, DataType<?> dataType) {
        this.relation = relation;
        this.column = column;
        this.dataType = dataType;
        this.identity = 0;
    }

    public ScopedSymbol(RelationName relation, ColumnIdent column, Symbol symbol) {
        this.relation = relation;
        this.column = column;
        this.dataType = symbol.valueType();
        this.identity = symbol.hashCode();
    }

    public RelationName relation() {
        return this.relation;
    }

    public ColumnIdent column() {
        return this.column;
    }

    @Override
    public ColumnIdent toColumn() {
        return this.column;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.RELATION_OUTPUT;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitField(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.dataType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("ScopedSymbol `" + this.toString(Style.QUALIFIED) + "` is not streamable. This error is a bug. Please create an issue in https://github.com/crate/crate/issues/new/choose");
    }

    public String toString() {
        return this.column.quotedOutputName();
    }

    @Override
    public String toString(Style style) {
        if (style == Style.QUALIFIED) {
            return this.relation.sqlFqn() + "." + this.column.quotedOutputName();
        }
        return this.column.quotedOutputName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ScopedSymbol)) return false;
        ScopedSymbol other = (ScopedSymbol)o;
        if (!this.relation.equals(other.relation)) return false;
        if (!this.column.equals(other.column)) return false;
        if (!this.dataType.equals(other.dataType)) return false;
        if (this.identity != other.identity) return false;
        return true;
    }

    public int hashCode() {
        int result = this.relation.hashCode();
        result = 31 * result + this.column.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.identity;
        return result;
    }

    public long ramBytesUsed() {
        return this.dataType.ramBytesUsed();
    }
}

