/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.RangeIterable;
import io.crate.legacy.LegacySettings;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TimestampType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.function.BinaryOperator;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.Period;

public final class GenerateSeries<T extends Number>
extends TableFunctionImplementation<T> {
    public static final FunctionName NAME = new FunctionName("pg_catalog", "generate_series");
    private final T defaultStep;
    private final BinaryOperator<T> minus;
    private final BinaryOperator<T> plus;
    private final BinaryOperator<T> divide;
    private final Comparator<T> comparator;
    private final RowType returnType;

    public static void register(Functions.Builder builder, Settings settings) {
        List fieldNames = LegacySettings.LEGACY_TABLE_FUNCTION_COLUMN_NAMING.get(settings) != false ? List.of() : List.of(NAME.name());
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(DataTypes.LONG.getTypeSignature(), DataTypes.LONG.getTypeSignature()).returnType(DataTypes.LONG.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new GenerateSeries<Long>((Signature)signature, (BoundSignature)boundSignature, 1L, (x, y) -> x - y, Long::sum, (x, y) -> x / y, Long::compare, new RowType(List.of(boundSignature.argTypes().get(0)), fieldNames)));
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new GenerateSeries<Integer>((Signature)signature, (BoundSignature)boundSignature, 1, (x, y) -> x - y, Integer::sum, (x, y) -> x / y, Integer::compare, new RowType(List.of(boundSignature.argTypes().get(0)), fieldNames)));
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(DataTypes.LONG.getTypeSignature(), DataTypes.LONG.getTypeSignature(), DataTypes.LONG.getTypeSignature()).returnType(DataTypes.LONG.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new GenerateSeries<Long>((Signature)signature, (BoundSignature)boundSignature, 1L, (x, y) -> x - y, Long::sum, (x, y) -> x / y, Long::compare, new RowType(List.of(boundSignature.argTypes().get(0)), fieldNames)));
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new GenerateSeries<Integer>((Signature)signature, (BoundSignature)boundSignature, 1, (x, y) -> x - y, Integer::sum, (x, y) -> x / y, Integer::compare, new RowType(List.of(boundSignature.argTypes().get(0)), fieldNames)));
        for (TimestampType supportedType : List.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ)) {
            builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(supportedType.getTypeSignature(), supportedType.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()).returnType(supportedType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new GenerateSeriesIntervals((Signature)signature, (BoundSignature)boundSignature, new RowType(List.of(boundSignature.argTypes().get(0)), fieldNames)));
            builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(supportedType.getTypeSignature(), supportedType.getTypeSignature()).returnType(supportedType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> {
                throw new IllegalArgumentException("generate_series(start, stop) has type `" + boundSignature.argTypes().get(0).getName() + "` for start, but requires long/int values for start and stop, or if used with timestamps, it requires a third argument for the step (interval)");
            });
        }
    }

    private GenerateSeries(Signature signature, BoundSignature boundSignature, T defaultStep, BinaryOperator<T> minus, BinaryOperator<T> plus, BinaryOperator<T> divide, Comparator<T> comparator, RowType returnType) {
        super(signature, boundSignature);
        this.defaultStep = defaultStep;
        this.minus = minus;
        this.plus = plus;
        this.divide = divide;
        this.comparator = comparator;
        this.returnType = returnType;
    }

    @Override
    public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        T step;
        assert (args.length == 2 || args.length == 3) : "Signature must ensure that there are either two or three arguments";
        Number startInclusive = (Number)args[0].value();
        Number stopInclusive = (Number)args[1].value();
        Object object = step = args.length == 3 ? (Number)args[2].value() : this.defaultStep;
        if (startInclusive == null || stopInclusive == null || step == null) {
            return List.of();
        }
        Number diff = (Number)this.minus.apply((Number)this.plus.apply(stopInclusive, step), startInclusive);
        int numRows = Math.max(0, ((Number)this.divide.apply(diff, step)).intValue());
        if (numRows == 0) {
            return List.of();
        }
        return new RangeIterable<Number>(startInclusive, stopInclusive, value -> (Number)this.plus.apply((Number)value, step), this.comparator, t -> t);
    }

    @Override
    public RowType returnType() {
        return this.returnType;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }

    private static class GenerateSeriesIntervals
    extends TableFunctionImplementation<Object> {
        private final RowType returnType;

        public GenerateSeriesIntervals(Signature signature, BoundSignature boundSignature, RowType returnType) {
            super(signature, boundSignature);
            this.returnType = returnType;
        }

        @Override
        public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
            ZonedDateTime stop;
            boolean reverse;
            Long startInclusive = (Long)args[0].value();
            Long stopInclusive = (Long)args[1].value();
            Period step = (Period)args[2].value();
            if (startInclusive == null || stopInclusive == null || step == null) {
                return List.of();
            }
            ZonedDateTime start = Instant.ofEpochMilli(startInclusive).atZone(ZoneOffset.UTC);
            boolean bl = reverse = start.compareTo(stop = Instant.ofEpochMilli(stopInclusive).atZone(ZoneOffset.UTC)) > 0;
            if (reverse && GenerateSeriesIntervals.add(start, step).compareTo(start) >= 0) {
                return List.of();
            }
            return new RangeIterable<ZonedDateTime>(start, stop, value -> GenerateSeriesIntervals.add(value, step), ChronoZonedDateTime::compareTo, value -> value.toEpochSecond() * 1000L);
        }

        private static ZonedDateTime add(ZonedDateTime dateTime, Period step) {
            return dateTime.plusYears(step.getYears()).plusMonths(step.getMonths()).plusWeeks(step.getWeeks()).plusDays(step.getDays()).plusHours(step.getHours()).plusMinutes(step.getMinutes()).plusSeconds(step.getSeconds()).plusNanos((long)step.getMillis() * 10000000L);
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return true;
        }
    }
}

