/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.Function;

public final class PgExpandArray
extends TableFunctionImplementation<List<Object>> {
    private static final String NAME = "_pg_expandarray";
    private static final FunctionName FUNCTION_NAME = new FunctionName("information_schema", "_pg_expandarray");
    private final RowType resultType;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(FUNCTION_NAME, FunctionType.TABLE).argumentTypes(TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("record(x E, n integer)")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), PgExpandArray::new);
    }

    public PgExpandArray(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayType argType = (ArrayType)boundSignature.argTypes().get(0);
        this.resultType = new RowType(List.of(argType.innerType(), DataTypes.INTEGER), List.of("x", "n"));
    }

    @Override
    @SafeVarargs
    public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        List values = (List)args[0].value();
        if (values == null) {
            return List.of();
        }
        return () -> values.stream().map(new Function<Object, Row>(this){
            final Object[] columns = new Object[2];
            final RowN row = new RowN(this.columns);
            int idx = 0;

            @Override
            public Row apply(Object val) {
                ++this.idx;
                this.columns[0] = val;
                this.columns[1] = this.idx;
                return this.row;
            }
        }).iterator();
    }

    @Override
    public RowType returnType() {
        return this.resultType;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }
}

