/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DropUserDefinedFunctionRequest
extends MasterNodeRequest<DropUserDefinedFunctionRequest> {
    private final String name;
    private final String schema;
    private final List<DataType<?>> argumentTypes;
    private final boolean ifExists;

    public DropUserDefinedFunctionRequest(String schema, String name, List<DataType<?>> argumentTypes, boolean ifExists) {
        this.schema = schema;
        this.name = name;
        this.argumentTypes = argumentTypes;
        this.ifExists = ifExists;
    }

    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public List<DataType<?>> argumentTypes() {
        return this.argumentTypes;
    }

    boolean ifExists() {
        return this.ifExists;
    }

    public DropUserDefinedFunctionRequest(StreamInput in) throws IOException {
        super(in);
        this.schema = in.readString();
        this.name = in.readString();
        int n = in.readVInt();
        if (n > 0) {
            this.argumentTypes = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.argumentTypes.add(DataTypes.fromStream(in));
            }
        } else {
            this.argumentTypes = List.of();
        }
        this.ifExists = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.schema);
        out.writeString(this.name);
        int n = this.argumentTypes.size();
        out.writeVInt(n);
        for (int i = 0; i < n; ++i) {
            DataTypes.toStream(this.argumentTypes.get(i), out);
        }
        out.writeBoolean(this.ifExists);
    }
}

