/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.udf;

import io.crate.exceptions.ScriptException;
import io.crate.expression.udf.CreateUserDefinedFunctionRequest;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionService;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateUserDefinedFunction
extends TransportMasterNodeAction<CreateUserDefinedFunctionRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final UserDefinedFunctionService udfService;

    @Inject
    public TransportCreateUserDefinedFunction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, UserDefinedFunctionService udfService) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateUserDefinedFunctionRequest::new);
        this.udfService = udfService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreateUserDefinedFunctionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        UserDefinedFunctionMetadata metadata = request.userDefinedFunctionMetadata();
        String errorMessage = this.udfService.getLanguage(metadata.language()).validate(metadata);
        if (errorMessage != null) {
            throw new ScriptException(errorMessage, metadata.language());
        }
        this.udfService.registerFunction(metadata, request.replace(), listener, request.masterNodeTimeout());
    }

    @Override
    protected ClusterBlockException checkBlock(CreateUserDefinedFunctionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/udf/create";

        private Action() {
            super(NAME);
        }
    }
}

