/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.exceptions.RelationAlreadyExists;
import io.crate.fdw.CreateForeignTableRequest;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.RelationName;
import java.util.Locale;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public final class AddForeignTableTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final CreateForeignTableRequest request;

    public AddForeignTableTask(CreateForeignTableRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        RelationName tableName = this.request.tableName();
        Metadata metadata = currentState.metadata();
        if (metadata.contains(tableName)) {
            if (this.request.ifNotExists()) {
                return currentState;
            }
            throw new RelationAlreadyExists(tableName);
        }
        ServersMetadata serversMetadata = metadata.custom("servers", ServersMetadata.EMPTY);
        if (!serversMetadata.contains(this.request.server())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot create foreign table for server `%s`. It doesn't exist. Create it using CREATE SERVER", this.request.server()));
        }
        ForeignTablesMetadata foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        ForeignTablesMetadata updatedTables = foreignTables.add(tableName, this.request.columns(), this.request.server(), this.request.options());
        return ClusterState.builder(currentState).metadata(Metadata.builder(metadata).putCustom("foreign_tables", updatedTables)).build();
    }
}

