/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class AlterServerRequest
extends AcknowledgedRequest<AlterServerRequest> {
    private final String name;
    private final Settings optionsAdded;
    private final Settings optionsUpdated;
    private final List<String> optionsRemoved;

    public AlterServerRequest(String name, Settings optionsAdded, Settings optionsUpdated, List<String> optionsRemoved) {
        this.name = name;
        this.optionsAdded = optionsAdded;
        this.optionsUpdated = optionsUpdated;
        this.optionsRemoved = optionsRemoved;
    }

    public AlterServerRequest(StreamInput in) throws IOException {
        this.name = in.readString();
        this.optionsAdded = Settings.readSettingsFromStream(in);
        this.optionsUpdated = Settings.readSettingsFromStream(in);
        this.optionsRemoved = in.readList(StreamInput::readString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        Settings.writeSettingsToStream(out, this.optionsAdded);
        Settings.writeSettingsToStream(out, this.optionsUpdated);
        out.writeCollection(this.optionsRemoved, StreamOutput::writeString);
    }

    public String name() {
        return this.name;
    }

    public Settings optionsAdded() {
        return this.optionsAdded;
    }

    public Settings optionsUpdated() {
        return this.optionsUpdated;
    }

    public List<String> optionsRemoved() {
        return this.optionsRemoved;
    }
}

