/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.DropForeignTableRequest;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.sql.tree.CascadeMode;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public class DropForeignTableTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private DropForeignTableRequest request;

    DropForeignTableTask(DropForeignTableRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        ForeignTablesMetadata updatedTables;
        if (this.request.cascadeMode() == CascadeMode.CASCADE) {
            throw new UnsupportedOperationException("DROP FOREIGN TABLE with CASCADE is not supported");
        }
        Metadata metadata = currentState.metadata();
        ForeignTablesMetadata foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        if (foreignTables == (updatedTables = foreignTables.remove(this.request.names(), this.request.ifExists()))) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(Metadata.builder(metadata).putCustom("foreign_tables", updatedTables)).build();
    }
}

