/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.sql.Identifiers;
import io.crate.types.DataType;
import io.crate.types.ResultSetParser;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcBatchIterator
implements BatchIterator<Row> {
    private static final Logger LOGGER = LogManager.getLogger(JdbcBatchIterator.class);
    private final String url;
    private final Properties properties;
    private final Row row;
    private final Object[] cells;
    private final List<Reference> columns;
    private final Symbol query;
    private final RelationName table;
    private Connection conn;
    private PreparedStatement statement;
    private ResultSet resultSet;
    private volatile Throwable killed = null;

    public JdbcBatchIterator(String url, Properties properties, List<Reference> columns, Symbol query, RelationName table) {
        this.url = url;
        this.properties = properties;
        this.columns = columns;
        this.query = query;
        this.table = table;
        this.cells = new Object[columns.size()];
        this.row = new RowN(this.cells);
    }

    static String generateStatement(RelationName table, List<Reference> columns, Symbol query, String quoteString) {
        String qs = quoteString.isBlank() ? "" : quoteString;
        StringBuilder relationName = new StringBuilder();
        String schema = table.schema();
        if (schema != null) {
            relationName.append(qs).append(schema).append(qs).append('.');
        }
        relationName.append(qs).append(table.name()).append(qs);
        String columnsStr = columns.isEmpty() ? "1" : String.join((CharSequence)", ", Lists.mapLazy(columns, ref -> new QuotedReference((Reference)ref, qs).toString(Style.UNQUALIFIED)));
        String stmt = String.format(Locale.ENGLISH, "SELECT %s FROM %s WHERE %s", columnsStr, relationName.toString(), RefReplacer.replaceRefs(query, ref -> new QuotedReference((Reference)ref, qs)).toString(Style.UNQUALIFIED));
        LOGGER.debug("Generated statement for foreign JDBC source: {}", (Object)stmt);
        return stmt;
    }

    public void kill(@NotNull Throwable throwable) {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException ignored) {
            throwable.addSuppressed(ignored);
        }
        this.killed = throwable;
    }

    public Row currentElement() {
        return this.row;
    }

    public void moveToStart() {
        this.raiseIfKilled();
        if (this.resultSet != null) {
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException e) {
                this.resultSet = null;
            }
        }
    }

    public boolean moveNext() {
        this.raiseIfKilled();
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (this.resultSet.next()) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    Reference ref = this.columns.get(i);
                    ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
                    Object object = ResultSetParser.getObject(this.resultSet, i, resultSetMetaData.getColumnTypeName(i + 1));
                    try {
                        this.cells[i] = ref.valueType().implicitCast(object);
                        continue;
                    }
                    catch (ClassCastException | IllegalArgumentException e) {
                        ConversionException conversionException = new ConversionException(object, ref.valueType());
                        conversionException.addSuppressed(e);
                        throw conversionException;
                    }
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw Exceptions.toRuntimeException((Throwable)e);
        }
    }

    public void close() {
        if (this.killed != null) {
            this.killed = BatchIterator.CLOSED;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                throw Exceptions.toRuntimeException((Throwable)e);
            }
        }
    }

    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.conn == null) {
            this.conn = DriverManager.getConnection(this.url, this.properties);
        }
        if (this.statement == null) {
            DatabaseMetaData metaData = this.conn.getMetaData();
            String sql = JdbcBatchIterator.generateStatement(this.table, this.columns, this.query, metaData.getIdentifierQuoteString());
            this.statement = this.conn.prepareStatement(sql);
        }
        this.resultSet = this.statement.executeQuery();
        return CompletableFuture.completedFuture(null);
    }

    public boolean allLoaded() {
        return this.resultSet != null;
    }

    public boolean hasLazyResultSet() {
        return true;
    }

    private void raiseIfKilled() {
        if (this.killed != null) {
            Exceptions.rethrowUnchecked((Throwable)this.killed);
        }
    }

    static class QuotedReference
    implements Reference {
        private final Reference ref;
        private final String quoteString;

        private QuotedReference(Reference ref, String quoteString) {
            this.ref = ref;
            this.quoteString = quoteString;
        }

        @Override
        public String toString(Style style) {
            ColumnIdent column = this.ref.column();
            StringBuilder sb = new StringBuilder();
            if (style == Style.QUALIFIED) {
                RelationName tableIdent = this.ref.ident().tableIdent();
                String schema = tableIdent.schema();
                if (schema != null) {
                    sb.append(this.quoteString);
                    sb.append(schema);
                    sb.append(this.quoteString);
                    sb.append('.');
                }
                sb.append(this.quoteString);
                sb.append(tableIdent.name());
                sb.append(this.quoteString);
            }
            sb.append(this.quoteString);
            sb.append(Identifiers.escape((String)column.sqlFqn()));
            sb.append(this.quoteString);
            return sb.toString();
        }

        public long ramBytesUsed() {
            return this.ref.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.ref.getChildResources();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.ref.writeTo(out);
        }

        @Override
        public ReferenceIdent ident() {
            return this.ref.ident();
        }

        @Override
        public ColumnIdent column() {
            return this.ref.column();
        }

        @Override
        public SymbolType symbolType() {
            return this.ref.symbolType();
        }

        @Override
        public IndexType indexType() {
            return this.ref.indexType();
        }

        @Override
        public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
            return this.ref.accept(visitor, context);
        }

        @Override
        public boolean isNullable() {
            return this.ref.isNullable();
        }

        @Override
        public DataType<?> valueType() {
            return this.ref.valueType();
        }

        @Override
        public RowGranularity granularity() {
            return this.ref.granularity();
        }

        @Override
        public Symbol cast(DataType<?> targetType, CastMode ... modes) {
            return this.ref.cast(targetType, modes);
        }

        @Override
        public int position() {
            return this.ref.position();
        }

        @Override
        public long oid() {
            return this.ref.oid();
        }

        @Override
        public boolean isDropped() {
            return this.ref.isDropped();
        }

        @Override
        public boolean hasDocValues() {
            return this.ref.hasDocValues();
        }

        @Override
        @Nullable
        public Symbol defaultExpression() {
            return this.ref.defaultExpression();
        }

        @Override
        public boolean isGenerated() {
            return this.ref.isGenerated();
        }

        @Override
        public Reference withReferenceIdent(ReferenceIdent referenceIdent) {
            return this.ref.withReferenceIdent(referenceIdent);
        }

        @Override
        public Reference withOidAndPosition(LongSupplier acquireOid, IntSupplier acquirePosition) {
            return this.ref.withOidAndPosition(acquireOid, acquirePosition);
        }

        @Override
        public Reference withDropped(boolean dropped) {
            return this.ref.withDropped(dropped);
        }

        @Override
        public Reference withValueType(DataType<?> type) {
            return this.ref.withValueType(type);
        }

        @Override
        public String storageIdent() {
            return this.ref.storageIdent();
        }

        @Override
        public String storageIdentLeafName() {
            return this.ref.storageIdentLeafName();
        }

        @Override
        public Map<String, Object> toMapping(int position) {
            return this.ref.toMapping(position);
        }
    }
}

