/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.AddUserMappingTask;
import io.crate.fdw.CreateUserMappingRequest;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateUserMapping
extends TransportMasterNodeAction<CreateUserMappingRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportCreateUserMapping(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateUserMappingRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreateUserMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (state.nodes().getMinNodeVersion().before(Version.V_5_7_0)) {
            throw new IllegalStateException("Cannot execute CREATE USER MAPPING while there are <5.7.0 nodes in the cluster");
        }
        AddUserMappingTask updateTask = new AddUserMappingTask(request);
        updateTask.completionFuture().whenComplete(listener);
        this.clusterService.submitStateUpdateTask("create_user_mapping", updateTask);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateUserMappingRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/fdw/user/create";

        private Action() {
            super(NAME);
        }
    }
}

