/*
 * Decompiled with CFR 0.152.
 */
package io.crate.interval;

import io.crate.interval.IntervalParser;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

final class SQLStandardIntervalParser {
    private static final Pattern YEAR_MONTH_PATTERN = Pattern.compile("-?\\d{1,9}-\\d{1,9}");

    SQLStandardIntervalParser() {
    }

    static Period apply(String value, @Nullable IntervalParser.Precision start, @Nullable IntervalParser.Precision end) {
        return IntervalParser.roundToPrecision(SQLStandardIntervalParser.apply(value), start, end);
    }

    static Period apply(String value) {
        String[] values = value.split(" ");
        if (values.length > 3 || values.length == 0) {
            throw new IllegalArgumentException("Invalid interval format: " + value);
        }
        ParserState state = ParserState.NOTHING_PARSED;
        boolean negative = false;
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        try {
            for (int i = values.length - 1; i >= 0; --i) {
                String part = values[i];
                if (part.isBlank()) continue;
                if (part.startsWith("-")) {
                    negative = true;
                    part = part.substring(1);
                }
                if (part.startsWith("+")) {
                    part = part.substring(1);
                }
                if (part.contains(":")) {
                    String[] hms = part.split(":");
                    if (hms.length == 3) {
                        hours = IntervalParser.nullSafeIntGet(hms[0]);
                        minutes = IntervalParser.nullSafeIntGet(hms[1]);
                        seconds = IntervalParser.nullSafeIntGet(hms[2]);
                    } else if (hms.length == 2) {
                        hours = IntervalParser.nullSafeIntGet(hms[0]);
                        minutes = IntervalParser.nullSafeIntGet(hms[1]);
                    } else if (hms.length == 1) {
                        seconds = IntervalParser.nullSafeIntGet(hms[0]);
                    } else {
                        throw new IllegalArgumentException("Invalid interval format: " + value);
                    }
                    if (negative) {
                        hours = -hours;
                        minutes = -minutes;
                        seconds = -seconds;
                        negative = false;
                    }
                    state = ParserState.HMS_PARSED;
                    continue;
                }
                if (part.contains("-")) {
                    String[] ym = part.split("-");
                    if (ym.length != 2) {
                        throw new IllegalArgumentException("Invalid interval format: " + value);
                    }
                    years = IntervalParser.nullSafeIntGet(ym[0]);
                    months = IntervalParser.nullSafeIntGet(ym[1]);
                    if (negative) {
                        years = -years;
                        months = -months;
                        negative = false;
                    }
                    state = ParserState.YEAR_MONTH_PARSED;
                    continue;
                }
                if (state == ParserState.NOTHING_PARSED) {
                    int number = IntervalParser.nullSafeIntGet(part);
                    if (i - 1 >= 0) {
                        String next = values[i - 1];
                        if (YEAR_MONTH_PATTERN.matcher(next).matches()) {
                            days = number;
                            if (negative) {
                                days = -days;
                                negative = false;
                            }
                            state = ParserState.DAYS_PARSED;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid interval format: " + value);
                    }
                    seconds = number;
                    if (negative) {
                        seconds = -seconds;
                        negative = false;
                    }
                    state = ParserState.SECOND_PARSED;
                    continue;
                }
                if (state == ParserState.HMS_PARSED) {
                    days = IntervalParser.nullSafeIntGet(part);
                    if (negative) {
                        days = -days;
                        negative = false;
                    }
                    state = ParserState.DAYS_PARSED;
                    continue;
                }
                if (state != ParserState.SECOND_PARSED) continue;
                throw new IllegalArgumentException("Invalid interval format: " + value);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid interval format: " + value);
        }
        if (ParserState.NOTHING_PARSED == state) {
            throw new IllegalArgumentException("Invalid interval format: " + value);
        }
        return new Period(years, months, 0, days, hours, minutes, seconds, 0);
    }

    private static enum ParserState {
        NOTHING_PARSED,
        HMS_PARSED,
        SECOND_PARSED,
        DAYS_PARSED,
        YEAR_MONTH_PARSED;

    }
}

