/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.common.collections.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;

public final class WrappingCollectorManager<CIn extends Collector, COut extends Collector, T>
implements CollectorManager<COut, T> {
    private final CollectorManager<CIn, T> delegate;
    private final Function<? super CIn, ? extends COut> wrap;
    private final Function<? super COut, ? extends CIn> unwrap;

    public WrappingCollectorManager(CollectorManager<CIn, T> delegate, Function<? super CIn, ? extends COut> wrap, Function<? super COut, ? extends CIn> unwrap) {
        this.delegate = delegate;
        this.wrap = wrap;
        this.unwrap = unwrap;
    }

    public COut newCollector() throws IOException {
        Collector collector = this.delegate.newCollector();
        return (COut)((Collector)this.wrap.apply(collector));
    }

    public T reduce(Collection<COut> collectors) throws IOException {
        return (T)this.delegate.reduce((Collection)Lists.map(collectors, this.unwrap));
    }
}

