/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.RelationName;
import io.crate.metadata.TableInfoFactory;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.settings.NumberOfReplicas;
import java.nio.file.Path;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.Nullable;

public class BlobTableInfoFactory
implements TableInfoFactory<BlobTableInfo> {
    private final Path[] dataFiles;
    private final Path globalBlobPath;

    public BlobTableInfoFactory(Settings settings, Environment environment) {
        this.dataFiles = environment.dataFiles();
        this.globalBlobPath = BlobIndicesService.getGlobalBlobPath(settings);
    }

    @Nullable
    private IndexMetadata resolveIndexMetadata(String tableName, Metadata metadata) {
        Index index;
        String indexName = BlobIndex.fullIndexName(tableName);
        try {
            index = IndexNameExpressionResolver.concreteIndices(metadata, IndicesOptions.STRICT_EXPAND_OPEN, indexName)[0];
        }
        catch (IndexNotFoundException ex) {
            return null;
        }
        return metadata.index(index);
    }

    @Override
    public BlobTableInfo create(RelationName ident, Metadata metadata) {
        IndexMetadata indexMetadata = this.resolveIndexMetadata(ident.name(), metadata);
        if (indexMetadata == null) {
            RelationMetadata.BlobTable blobTable = (RelationMetadata.BlobTable)metadata.getRelation(ident);
            if (blobTable == null) {
                throw new RelationUnknown(ident);
            }
            indexMetadata = metadata.indexByUUID(blobTable.indexUUID());
            if (indexMetadata == null) {
                throw new RelationUnknown(ident);
            }
        }
        return this.create(indexMetadata);
    }

    @Override
    public BlobTableInfo create(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        return new BlobTableInfo(RelationName.fromIndexName(indexMetadata.getIndex().getName()), indexMetadata.getIndex().getName(), indexMetadata.getNumberOfShards(), NumberOfReplicas.getVirtualValue(settings), settings, this.blobsPath(settings), IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings), settings.getAsVersion("index.version.upgraded", null), indexMetadata.getState() == IndexMetadata.State.CLOSE);
    }

    private String blobsPath(Settings indexMetadataSettings) {
        Path path;
        String blobsPathStr = BlobIndicesService.SETTING_INDEX_BLOBS_PATH.get(indexMetadataSettings);
        String blobsPath = Strings.hasLength(blobsPathStr) ? blobsPathStr : ((path = this.globalBlobPath) != null ? path.toString() : this.dataFiles[0].toString());
        return blobsPath;
    }
}

