/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.index.Index;

public class DropTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<DropTableRequest> {
    private final MetadataDeleteIndexService deleteIndexService;
    private final DDLClusterStateService ddlClusterStateService;

    public DropTableClusterStateTaskExecutor(MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        this.deleteIndexService = deleteIndexService;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, DropTableRequest request) throws Exception {
        RelationName relationName = request.tableIdent();
        Metadata currentMetadata = currentState.metadata();
        if (!currentMetadata.contains(relationName)) {
            throw new RelationUnknown(relationName);
        }
        List<Index> indices = currentMetadata.getIndices(relationName, List.of(), false, IndexMetadata::getIndex);
        Metadata.Builder newMetadata = Metadata.builder(currentMetadata).dropRelation(relationName);
        currentState = ClusterState.builder(currentState).metadata(newMetadata).build();
        currentState = this.deleteIndexService.deleteIndices(currentState, indices);
        currentState = this.ddlClusterStateService.onDropTable(currentState, relationName);
        return currentState;
    }
}

