/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.OpenTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;

public class OpenTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<OpenTableRequest> {
    private final AllocationService allocationService;
    private final DDLClusterStateService ddlClusterStateService;
    private final MetadataUpgradeService metadataIndexUpgradeService;
    private final IndicesService indicesService;

    public OpenTableClusterStateTaskExecutor(AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.indicesService = indexServices;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, OpenTableRequest request) throws Exception {
        Context context = this.prepare(currentState, request);
        List<IndexMetadata> closedIndices = context.closedIndices();
        RelationMetadata.Table table = (RelationMetadata.Table)currentState.metadata().getRelation(request.relation());
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        if (request.partitionValues().isEmpty()) {
            mdBuilder.setTable(table.name(), table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), IndexMetadata.State.OPEN, table.indexUUIDs(), table.tableVersion() + 1L);
        } else if (closedIndices.isEmpty()) {
            return currentState;
        }
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Version minIndexCompatibilityVersion = currentState.nodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
        for (IndexMetadata closedMetadata : closedIndices) {
            String indexName = closedMetadata.getIndex().getName();
            blocksBuilder.removeIndexBlockWithId(indexName, 4);
            if (closedMetadata.getState() == IndexMetadata.State.OPEN) continue;
            Settings.Builder updatedSettings = Settings.builder().put(closedMetadata.getSettings());
            updatedSettings.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
            IndexMetadata updatedIndexMetadata = IndexMetadata.builder(closedMetadata).state(IndexMetadata.State.OPEN).settingsVersion(closedMetadata.getSettingsVersion() + 1L).settings(updatedSettings).build();
            updatedIndexMetadata = this.metadataIndexUpgradeService.upgradeIndexMetadata(updatedIndexMetadata, null, minIndexCompatibilityVersion, null);
            try {
                this.indicesService.verifyIndexMetadata(updatedIndexMetadata, updatedIndexMetadata);
            }
            catch (Exception e) {
                throw new ElasticsearchException("Failed to verify index " + indexName, (Throwable)e, new Object[0]);
            }
            mdBuilder.put(updatedIndexMetadata, true);
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(mdBuilder).blocks(blocksBuilder).build();
        updatedState = context.partitionName() != null ? this.ddlClusterStateService.onOpenTablePartition(updatedState, context.partitionName()) : this.ddlClusterStateService.onOpenTable(updatedState, request.relation());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(updatedState.routingTable());
        for (IndexMetadata index : closedIndices) {
            rtBuilder.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(index.getIndex()));
        }
        return this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder.build()).build(), "indices opened " + String.valueOf(closedIndices));
    }

    private Context prepare(ClusterState currentState, OpenTableRequest request) {
        RelationName relationName = request.relation();
        List<String> partitionValues = request.partitionValues();
        Metadata metadata = currentState.metadata();
        List<IndexMetadata> closedIndices = metadata.getIndices(relationName, partitionValues, false, idx -> idx.getState() == IndexMetadata.State.CLOSE ? idx : null);
        PartitionName partitionName = partitionValues.isEmpty() ? null : new PartitionName(relationName, partitionValues);
        return new Context(closedIndices, partitionName);
    }

    private record Context(List<IndexMetadata> closedIndices, PartitionName partitionName) {
    }
}

