/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;

public class SysColumns {
    public static final ColumnIdent VERSION = ColumnIdent.of("_version");
    public static final ColumnIdent SCORE = ColumnIdent.of("_score");
    public static final ColumnIdent UID = ColumnIdent.of("_uid");
    public static final ColumnIdent DOC = ColumnIdent.of("_doc");
    public static final ColumnIdent RAW = ColumnIdent.of("_raw");
    public static final ColumnIdent SEQ_NO = ColumnIdent.of("_seq_no");
    public static final ColumnIdent PRIMARY_TERM = ColumnIdent.of("_primary_term");
    public static final ColumnIdent FETCHID = ColumnIdent.of("_fetchid");
    public static final ColumnIdent DOCID = ColumnIdent.of("_docid");
    public static final Map<ColumnIdent, DataType<?>> COLUMN_IDENTS = Map.of(DOC, DataTypes.UNTYPED_OBJECT, FETCHID, DataTypes.LONG, ID.COLUMN, DataTypes.STRING, RAW, DataTypes.STRING, SCORE, DataTypes.FLOAT, UID, DataTypes.STRING, VERSION, DataTypes.LONG, DOCID, DataTypes.INTEGER, SEQ_NO, DataTypes.LONG, PRIMARY_TERM, DataTypes.LONG);
    private static final Map<ColumnIdent, String> LUCENE_COLUMN_NAMES = Map.of(RAW, "_source", ID.COLUMN, UID.name());

    private static Reference newInfo(RelationName table, ColumnIdent column, DataType<?> dataType, int position) {
        return new SimpleReference(new ReferenceIdent(table, column), RowGranularity.DOC, dataType, IndexType.PLAIN, false, false, position, 0L, false, null);
    }

    public static void forTable(RelationName relationName, BiConsumer<ColumnIdent, Reference> consumer) {
        int position = 1;
        for (Map.Entry<ColumnIdent, DataType<?>> entry : COLUMN_IDENTS.entrySet()) {
            ColumnIdent columnIdent = entry.getKey();
            consumer.accept(columnIdent, SysColumns.newInfo(relationName, columnIdent, entry.getValue(), position++));
        }
    }

    public static List<Reference> forTable(RelationName relationName) {
        int position = 1;
        ArrayList<Reference> columns = new ArrayList<Reference>();
        for (Map.Entry<ColumnIdent, DataType<?>> entry : COLUMN_IDENTS.entrySet()) {
            columns.add(SysColumns.newInfo(relationName, entry.getKey(), entry.getValue(), position++));
        }
        return columns;
    }

    public static Reference forTable(RelationName table, ColumnIdent column) {
        return SysColumns.newInfo(table, column, COLUMN_IDENTS.get(column), 0);
    }

    public static String nameForLucene(ColumnIdent ident) {
        String name = LUCENE_COLUMN_NAMES.get(ident);
        if (name == null) {
            name = ident.name();
        }
        return name;
    }

    public static class Names {
        public static final String ID = "_id";
        public static final String VERSION = "_version";
        public static final String SCORE = "_score";
        public static final String UID = "_uid";
        public static final String DOC = "_doc";
        public static final String RAW = "_raw";
        public static final String SEQ_NO = "_seq_no";
        public static final String PRIMARY_TERM = "_primary_term";
        public static final String TOMBSTONE = "_tombstone";
        public static final String FETCHID = "_fetchid";
        public static final String DOCID = "_docid";
    }

    public static class ID {
        public static final ColumnIdent COLUMN = ColumnIdent.of("_id");
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class FieldNames {
        public static final String NAME = "_field_names";
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class Source {
        public static final String NAME = "_source";
        public static final String RECOVERY_NAME = "_recovery_source";
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

