/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import io.crate.types.DataType;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BoundVariables {
    private final Map<String, DataType<?>> typeVariables;
    private final IntObjectMap<DataType<?>> boundTypes;

    public BoundVariables(Map<String, DataType<?>> typeVariables) {
        this(typeVariables, (IntObjectMap<DataType<?>>)new IntObjectHashMap(0));
    }

    public BoundVariables(Map<String, DataType<?>> typeVariables, IntObjectMap<DataType<?>> boundTypes) {
        this.typeVariables = Map.copyOf(typeVariables);
        this.boundTypes = boundTypes;
    }

    public DataType<?> getTypeVariable(String variableName) {
        return this.typeVariables.get(variableName);
    }

    public boolean containsTypeVariable(String variableName) {
        return this.typeVariables.containsKey(variableName);
    }

    public Set<String> getTypeVariableNames() {
        return this.typeVariables.keySet();
    }

    @Nullable
    public DataType<?> getBoundType(int idx) {
        return (DataType)this.boundTypes.get(idx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundVariables that = (BoundVariables)o;
        return Objects.equals(this.typeVariables, that.typeVariables);
    }

    public int hashCode() {
        return Objects.hash(this.typeVariables);
    }

    public String toString() {
        return "BoundVariables{typeVariables=" + String.valueOf(this.typeVariables) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, DataType<?>> typeVariables = new HashMap();
        private final IntObjectMap<DataType<?>> boundTypes = new IntObjectHashMap();

        public DataType<?> getTypeVariable(String variableName) {
            return this.typeVariables.get(variableName);
        }

        public void setTypeVariable(String variableName, DataType<?> variableValue) {
            this.typeVariables.put(variableName, variableValue);
        }

        public boolean containsTypeVariable(String variableName) {
            return this.typeVariables.containsKey(variableName);
        }

        public boolean setBoundType(int idx, DataType<?> boundType) {
            DataType existingType = (DataType)this.boundTypes.put(idx, boundType);
            return !boundType.equals(existingType);
        }

        public BoundVariables build() {
            return new BoundVariables(this.typeVariables, this.boundTypes);
        }
    }
}

