/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class TypeVariableConstraint
implements Writeable {
    private final String name;
    private final boolean anyAllowed;

    public static TypeVariableConstraint typeVariable(String name) {
        return new TypeVariableConstraint(name, false);
    }

    public static TypeVariableConstraint typeVariableOfAnyType(String name) {
        return new TypeVariableConstraint(name, true);
    }

    private TypeVariableConstraint(String name, boolean anyAllowed) {
        this.name = name;
        this.anyAllowed = anyAllowed;
    }

    public TypeVariableConstraint(StreamInput in) throws IOException {
        this.name = in.readString();
        this.anyAllowed = in.readBoolean();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnyAllowed() {
        return this.anyAllowed;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.anyAllowed);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

