/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings.session;

import io.crate.common.collections.MapBuilder;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.SearchPath;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.SessionSettings;
import io.crate.metadata.settings.session.NamedSessionSetting;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingProvider;
import io.crate.types.BooleanType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.joda.time.Period;
import org.joda.time.PeriodType;

@Singleton
public class SessionSettingRegistry {
    public static final String SEARCH_PATH_KEY = "search_path";
    public static final String HASH_JOIN_KEY = "enable_hashjoin";
    public static final String ERROR_ON_UNKNOWN_OBJECT_KEY = "error_on_unknown_object_key";
    public static final String APPLICATION_NAME_KEY = "application_name";
    public static final String DATE_STYLE_KEY = "datestyle";
    public static final String INSERT_SELECT_FAIL_FAST_KEY = "insert_select_fail_fast";
    static final String MAX_INDEX_KEYS = "max_index_keys";
    static final String MAX_IDENTIFIER_LENGTH = "max_identifier_length";
    static final String SERVER_VERSION_NUM = "server_version_num";
    static final String SERVER_VERSION = "server_version";
    static final String STANDARD_CONFORMING_STRINGS = "standard_conforming_strings";
    static final SessionSetting<String> APPLICATION_NAME = new SessionSetting<String>("application_name", inputs -> DataTypes.STRING.implicitCast(inputs[0]), CoordinatorSessionSettings::setApplicationName, SessionSettings::applicationName, () -> null, "Optional application name. Can be set by a client to identify the application which created the connection", DataTypes.STRING);
    static final SessionSetting<String> DATE_STYLE = new SessionSetting<String>("datestyle", inputs -> {
        SessionSettingRegistry.validateDateStyleFrom(SessionSettingRegistry.objectsToStringArray(inputs));
        return "ISO";
    }, CoordinatorSessionSettings::setDateStyle, SessionSettings::dateStyle, () -> "ISO", "Display format for date and time values.", DataTypes.STRING);
    static final SessionSetting<TimeValue> STATEMENT_TIMEOUT = new SessionSetting<TimeValue>("statement_timeout", inputs -> {
        Object input = inputs[0];
        if (input instanceof Number) {
            Number num = (Number)input;
            return TimeValue.timeValueMillis((long)num.longValue());
        }
        if (input instanceof String) {
            String str = (String)input;
            try {
                int millis = Integer.parseInt(str);
                return TimeValue.timeValueMillis((long)millis);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Period period = DataTypes.INTERVAL.implicitCast(input).normalizedStandard(PeriodType.millis());
        return TimeValue.timeValueMillis((long)period.getMillis());
    }, CoordinatorSessionSettings::statementTimeout, settings -> settings.statementTimeout().toString(), () -> "0", "The maximum duration of any statement before it gets killed. Infinite/disabled if 0", DataTypes.INTERVAL);
    static final SessionSetting<Integer> MEMORY_LIMIT = new SessionSetting<Integer>("memory.operation_limit", inputs -> DataTypes.INTEGER.implicitCast(inputs[0]), SessionSettings::memoryLimit, settings -> Integer.toString(settings.memoryLimitInBytes()), () -> "0", "Memory limit in bytes for an individual operation. 0 by-passes the operation limit, relying entirely on the global circuit breaker limits", DataTypes.INTEGER);
    static final SessionSetting<Boolean> ALLOW_FAIL_ON_PARTIAL_WRITES = new SessionSetting<Boolean>("insert_select_fail_fast", inputs -> DataTypes.BOOLEAN.implicitCast(inputs[0]), SessionSettings::insertSelectFailFast, settings -> Boolean.toString(settings.insertSelectFailFast()), () -> "false", "Allows partial failure of 'INSERT FROM SELECT' statements", DataTypes.BOOLEAN);
    private final Map<String, SessionSetting<?>> settings;

    @Inject
    public SessionSettingRegistry(Set<SessionSettingProvider> sessionSettingProviders) {
        MapBuilder builder = MapBuilder.treeMapBuilder().put((Object)SEARCH_PATH_KEY, new SessionSetting<SearchPath>(SEARCH_PATH_KEY, objects -> SearchPath.createSearchPathFrom(SessionSettingRegistry.objectsToStringArray(objects)), CoordinatorSessionSettings::setSearchPath, s -> String.join((CharSequence)", ", s.searchPath().showPath()), () -> String.join((CharSequence)", ", SearchPath.pathWithPGCatalogAndDoc().showPath()), "Sets the schema search order.", DataTypes.STRING)).put((Object)HASH_JOIN_KEY, new SessionSetting<Boolean>(HASH_JOIN_KEY, objects -> {
            if (((Object[])objects).length != 1) {
                throw new IllegalArgumentException("enable_hashjoin should have only one argument.");
            }
            return DataTypes.BOOLEAN.implicitCast(objects[0]);
        }, CoordinatorSessionSettings::setHashJoinEnabled, s -> Boolean.toString(s.hashJoinsEnabled()), () -> String.valueOf(true), "Considers using the Hash Join instead of the Nested Loop Join implementation.", DataTypes.BOOLEAN)).put((Object)MAX_INDEX_KEYS, new SessionSetting<Object>(MAX_INDEX_KEYS, objectArray -> {
            throw new UnsupportedOperationException("\"max_index_keys\" cannot be changed.");
        }, (s, v) -> {}, s -> String.valueOf(32), () -> String.valueOf(32), "Shows the maximum number of index keys.", DataTypes.INTEGER)).put((Object)MAX_IDENTIFIER_LENGTH, new SessionSetting<Object>(MAX_IDENTIFIER_LENGTH, objectArray -> {
            throw new UnsupportedOperationException("\"max_identifier_length\" cannot be changed.");
        }, (s, v) -> {}, s -> String.valueOf(255), () -> String.valueOf(255), "Shows the maximum length of identifiers in bytes.", DataTypes.INTEGER)).put((Object)SERVER_VERSION_NUM, new SessionSetting<Object>(SERVER_VERSION_NUM, objectArray -> {
            throw new UnsupportedOperationException("\"server_version_num\" cannot be changed.");
        }, (s, v) -> {}, s -> String.valueOf(140000), () -> String.valueOf(140000), "Reports the emulated PostgreSQL version number", DataTypes.INTEGER)).put((Object)SERVER_VERSION, new SessionSetting<Object>(SERVER_VERSION, objectArray -> {
            throw new UnsupportedOperationException("\"server_version\" cannot be changed.");
        }, (s, v) -> {}, s -> String.valueOf("14.0"), () -> String.valueOf("14.0"), "Reports the emulated PostgreSQL version number", DataTypes.STRING)).put((Object)STANDARD_CONFORMING_STRINGS, new SessionSetting<Object[]>(STANDARD_CONFORMING_STRINGS, objects -> {
            if (((Object[])objects).length != 1) {
                throw new IllegalArgumentException("standard_conforming_strings should have only one argument.");
            }
            SessionSettingRegistry.validateStandardConformingStrings(SessionSettingRegistry.objectsToStringArray(objects)[0]);
            return objects;
        }, (s, v) -> {}, s -> "on", () -> "on", "Causes '...' strings to treat backslashes literally.", DataTypes.STRING)).put((Object)ERROR_ON_UNKNOWN_OBJECT_KEY, new SessionSetting<Boolean>(ERROR_ON_UNKNOWN_OBJECT_KEY, objects -> {
            if (((Object[])objects).length != 1) {
                throw new IllegalArgumentException("error_on_unknown_object_key should have only one argument.");
            }
            return DataTypes.BOOLEAN.implicitCast(objects[0]);
        }, CoordinatorSessionSettings::setErrorOnUnknownObjectKey, s -> Boolean.toString(s.errorOnUnknownObjectKey()), () -> String.valueOf(true), "Raises or suppresses ObjectKeyUnknownException when querying nonexistent keys to dynamic objects.", DataTypes.BOOLEAN)).put((Object)APPLICATION_NAME.name(), APPLICATION_NAME).put((Object)DATE_STYLE.name(), DATE_STYLE).put((Object)STATEMENT_TIMEOUT.name(), STATEMENT_TIMEOUT).put((Object)MEMORY_LIMIT.name(), MEMORY_LIMIT).put((Object)ALLOW_FAIL_ON_PARTIAL_WRITES.name(), ALLOW_FAIL_ON_PARTIAL_WRITES);
        for (SessionSettingProvider providers : sessionSettingProviders) {
            for (SessionSetting<?> setting : providers.sessionSettings()) {
                builder.put((Object)setting.name(), setting);
            }
        }
        this.settings = builder.immutableMap();
    }

    public Map<String, SessionSetting<?>> settings() {
        return this.settings;
    }

    public Iterable<NamedSessionSetting> namedSessionSettings(TransactionContext txnCtx) {
        return () -> this.settings.entrySet().stream().map(x -> new NamedSessionSetting((String)x.getKey(), (SessionSetting)x.getValue(), txnCtx)).iterator();
    }

    private static String[] objectsToStringArray(Object[] objects) {
        ArrayList<String> argumentList = new ArrayList<String>();
        for (int i = 0; i < objects.length; ++i) {
            String str = DataTypes.STRING.implicitCast(objects[i]);
            for (String element : str.split(",")) {
                argumentList.add(element.trim());
            }
        }
        return (String[])argumentList.toArray(String[]::new);
    }

    private static void validateDateStyleFrom(String ... strings) {
        block19: for (String s : strings) {
            String dateStyle;
            switch (dateStyle = s.toUpperCase(Locale.ENGLISH)) {
                case "ISO": {
                    continue block19;
                }
                case "SQL": 
                case "POSTGRES": 
                case "GERMAN": {
                    throw new IllegalArgumentException("Invalid value for parameter \"" + DATE_STYLE.name() + "\": \"" + dateStyle + "\". Valid values include: [\"ISO\"].");
                }
                case "MDY": 
                case "NONEURO": 
                case "NONEUROPEAN": 
                case "US": 
                case "DMY": 
                case "EURO": 
                case "EUROPEAN": 
                case "YMD": {
                    continue block19;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for parameter \"" + DATE_STYLE.name() + "\": \"" + dateStyle + "\". Valid values include: [\"ISO\"].");
                }
            }
        }
    }

    private static void validateStandardConformingStrings(String str) {
        if (BooleanType.INSTANCE.implicitCast(str) == Boolean.FALSE) {
            throw new UnsupportedOperationException("\"standard_conforming_strings\" cannot be changed.");
        }
    }
}

