/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.Maps;
import io.crate.metadata.IndexName;
import io.crate.metadata.upgrade.MetadataIndexUpgrader;
import io.crate.server.xcontent.XContentHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ColumnPositionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class IndexTemplateUpgrader {
    private final Logger logger = LogManager.getLogger(IndexTemplateUpgrader.class);
    public static final String TEMPLATE_NAME = "crate_defaults";

    public Map<String, IndexTemplateMetadata> upgrade(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> upgradedTemplates = this.archiveUnknownOrInvalidSettings(templates);
        upgradedTemplates.remove(TEMPLATE_NAME);
        return upgradedTemplates;
    }

    private HashMap<String, IndexTemplateMetadata> archiveUnknownOrInvalidSettings(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> upgradedTemplates = new HashMap<String, IndexTemplateMetadata>(templates.size());
        for (Map.Entry<String, IndexTemplateMetadata> entry : templates.entrySet()) {
            IndexTemplateMetadata templateMetadata = entry.getValue();
            Settings.Builder settingsBuilder = Settings.builder().put(templateMetadata.settings());
            String templateName = entry.getKey();
            if (!IndexName.isPartitioned(templateName)) {
                upgradedTemplates.put(templateName, templateMetadata);
                continue;
            }
            Settings settings = IndexScopedSettings.DEFAULT_SCOPED_SETTINGS.archiveUnknownOrInvalidSettings(settingsBuilder.build(), e -> {}, (e, ex) -> {}).filter(k -> !k.startsWith("archived."));
            IndexTemplateMetadata.Builder builder = IndexTemplateMetadata.builder(templateName).patterns(templateMetadata.patterns()).settings(settings);
            Map<String, Object> mappingSource = XContentHelper.toMap(templateMetadata.mapping().compressedReference(), XContentType.JSON);
            Map defaultMapping = (Map)Maps.get(mappingSource, (String)"default");
            boolean updated = MetadataIndexUpgrader.removeInvalidPropertyGeneratedByDroppingSysCols(defaultMapping);
            updated |= IndexTemplateUpgrader.populateColumnPositions(defaultMapping);
            if (defaultMapping.containsKey("_all")) {
                defaultMapping.remove("_all");
                updated = true;
            }
            if (updated |= MetadataIndexUpgrader.addIndexColumnSources((Map)Maps.get((Map)defaultMapping, (String)"properties"), defaultMapping, "")) {
                builder.putMapping(new CompressedXContent(mappingSource));
            } else {
                builder.putMapping(templateMetadata.mapping());
            }
            for (ObjectObjectCursor<String, AliasMetadata> objectObjectCursor : templateMetadata.aliases()) {
                builder.putAlias((AliasMetadata)objectObjectCursor.value);
            }
            upgradedTemplates.put(templateName, builder.build());
        }
        return upgradedTemplates;
    }

    public static boolean populateColumnPositions(Map<String, Object> mapping) {
        ColumnPositionResolver<Map<String, Object>> columnPositionResolver = new ColumnPositionResolver<Map<String, Object>>();
        int[] maxColumnPosition = new int[]{0};
        IndexTemplateUpgrader.populateColumnPositions("", mapping, 1, columnPositionResolver, new HashSet<Integer>(), maxColumnPosition);
        columnPositionResolver.updatePositions(maxColumnPosition[0]);
        return columnPositionResolver.numberOfColumnsToReposition() > 0;
    }

    private static void populateColumnPositions(String parentName, Map<String, Object> mapping, int currentDepth, ColumnPositionResolver<Map<String, Object>> columnPositionResolver, Set<Integer> takenPositions, int[] maxColumnPosition) {
        Map properties = (Map)Maps.get(mapping, (String)"properties");
        if (properties == null) {
            return;
        }
        TreeMap childrenColumnProperties = new TreeMap(Comparator.naturalOrder());
        for (Map.Entry e : properties.entrySet()) {
            String name = parentName + (String)e.getKey();
            Map columnProperties = (Map)e.getValue();
            Integer position = (Integer)(columnProperties = (Map)Maps.getOrDefault((Map)columnProperties, (String)"inner", (Object)columnProperties)).get("position");
            if (position == null || takenPositions.contains(position)) {
                columnPositionResolver.addColumnToReposition(name, null, columnProperties, (cp, p) -> cp.put("position", p), currentDepth);
            } else {
                takenPositions.add(position);
                maxColumnPosition[0] = Math.max(maxColumnPosition[0], position);
            }
            childrenColumnProperties.put(name, columnProperties);
        }
        for (Map.Entry childColumnProperties : childrenColumnProperties.entrySet()) {
            IndexTemplateUpgrader.populateColumnPositions((String)childColumnProperties.getKey(), (Map)childColumnProperties.getValue(), currentDepth + 1, columnPositionResolver, takenPositions, maxColumnPosition);
        }
    }
}

