/*
 * Decompiled with CFR 0.152.
 */
package io.crate.monitor;

import org.elasticsearch.monitor.fs.FsInfo;

public class FsInfoHelpers {

    public static class Stats {
        public static Long readOperations(FsInfo.IoStats ioStats) {
            if (ioStats != null) {
                return ioStats.getTotalReadOperations();
            }
            return -1L;
        }

        public static Long bytesRead(FsInfo.IoStats ioStats) {
            if (ioStats != null) {
                return ioStats.getTotalReadKilobytes() * 1024L;
            }
            return -1L;
        }

        public static Long writeOperations(FsInfo.IoStats ioStats) {
            if (ioStats != null) {
                return ioStats.getTotalWriteOperations();
            }
            return -1L;
        }

        public static Long bytesWritten(FsInfo.IoStats ioStats) {
            if (ioStats != null) {
                return ioStats.getTotalWriteKilobytes() * 1024L;
            }
            return -1L;
        }
    }

    public static class Path {
        public static String dev(FsInfo.Path path) {
            return path.getMount() == null ? "" : path.getMount();
        }

        public static Long size(FsInfo.Path path) {
            return path.getTotal().getBytes();
        }

        public static Long used(FsInfo.Path path) {
            return path.getTotal().getBytes() == -1L || path.getAvailable().getBytes() == -1L ? -1L : path.getTotal().getBytes() - path.getAvailable().getBytes();
        }

        public static Long available(FsInfo.Path path) {
            return path.getAvailable().getBytes();
        }
    }
}

