/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedDecommissionNode;
import io.crate.analyze.SymbolEvaluator;
import io.crate.cluster.decommission.DecommissionNodeAction;
import io.crate.cluster.decommission.DecommissionRequest;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.NodeSelection;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.jetbrains.annotations.VisibleForTesting;

public final class DecommissionNodePlan
implements Plan {
    private final AnalyzedDecommissionNode analyzedDecommissionNode;

    DecommissionNodePlan(AnalyzedDecommissionNode analyzedDecommissionNode) {
        this.analyzedDecommissionNode = analyzedDecommissionNode;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        String boundedNodeIdOrName = DecommissionNodePlan.boundNodeIdOrName(this.analyzedDecommissionNode, plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
        String targetNodeId = NodeSelection.resolveNodeId(dependencies.clusterService().state().nodes(), boundedNodeIdOrName);
        dependencies.client().execute(DecommissionNodeAction.INSTANCE, DecommissionRequest.of(targetNodeId)).whenComplete(new OneRowActionListener<AcknowledgedResponse>(consumer, r -> r.isAcknowledged() ? new Row1((Object)1L) : new Row1((Object)0L)));
    }

    @VisibleForTesting
    public static String boundNodeIdOrName(AnalyzedDecommissionNode decommissionNode, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        Object boundedNodeIdOrName = SymbolEvaluator.evaluate(txnCtx, nodeCtx, decommissionNode.nodeIdOrName(), parameters, subQueryResults);
        return DataTypes.STRING.sanitizeValue(boundedNodeIdOrName);
    }
}

