/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.consumer;

import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.AnalyzedCreateTableAs;
import io.crate.analyze.BoundCreateTable;
import io.crate.analyze.NumberOfShards;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.ddl.tables.CreateTableClient;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.SubQueryResults;
import java.util.function.Supplier;

public final class CreateTableAsPlan
implements Plan {
    private final AnalyzedCreateTable analyzedCreateTable;
    private final Supplier<LogicalPlan> postponedInsertPlan;
    private final CreateTableClient createTableClient;
    private final NumberOfShards numberOfShards;

    public static CreateTableAsPlan of(AnalyzedCreateTableAs analyzedCreateTableAs, NumberOfShards numberOfShards, CreateTableClient tableCreator, PlannerContext context, LogicalPlanner logicalPlanner) {
        Supplier<LogicalPlan> postponedInsertPlan = () -> logicalPlanner.plan(analyzedCreateTableAs.analyzePostponedInsertStatement(), context);
        return new CreateTableAsPlan(analyzedCreateTableAs.analyzedCreateTable(), postponedInsertPlan, tableCreator, numberOfShards);
    }

    public CreateTableAsPlan(AnalyzedCreateTable analyzedCreateTable, Supplier<LogicalPlan> postponedInsertPlan, CreateTableClient createTableClient, NumberOfShards numberOfShards) {
        this.analyzedCreateTable = analyzedCreateTable;
        this.postponedInsertPlan = postponedInsertPlan;
        this.createTableClient = createTableClient;
        this.numberOfShards = numberOfShards;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        BoundCreateTable boundCreateTable = this.analyzedCreateTable.bind(this.numberOfShards, dependencies.fulltextAnalyzerResolver(), plannerContext.nodeContext(), plannerContext.transactionContext(), params, subQueryResults);
        this.createTableClient.create(boundCreateTable, plannerContext.clusterState().nodes().getMinNodeVersion()).whenComplete((rowCount, err) -> {
            if (err == null) {
                this.postponedInsertPlan.get().execute(dependencies, plannerContext, consumer, params, subQueryResults);
            } else if (boundCreateTable.ifNotExists() && CreateTableClient.isTableExistsError(err, boundCreateTable.templateName())) {
                consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
            } else {
                consumer.accept(null, err);
            }
        });
    }
}

