/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.consumer;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.inject.Singleton;
import org.jetbrains.annotations.Nullable;

@Singleton
public class OrderByPositionVisitor
extends SymbolVisitor<Context, Void> {
    private static final OrderByPositionVisitor INSTANCE = new OrderByPositionVisitor();

    private OrderByPositionVisitor() {
    }

    @Nullable
    public static int[] orderByPositionsOrNull(Collection<? extends Symbol> orderBySymbols, List<? extends Symbol> outputSymbols) {
        Context context = new Context(outputSymbols);
        for (Symbol symbol : orderBySymbols) {
            symbol.accept(INSTANCE, context);
        }
        if (context.orderByPositions.size() == orderBySymbols.size()) {
            return context.orderByPositions();
        }
        return null;
    }

    public static int[] orderByPositions(Collection<? extends Symbol> orderBySymbols, List<? extends Symbol> outputSymbols) {
        int[] positions = OrderByPositionVisitor.orderByPositionsOrNull(orderBySymbols, outputSymbols);
        if (positions == null) {
            throw new IllegalArgumentException("Must have an orderByPosition for each symbol. Got ORDER BY " + String.valueOf(orderBySymbols) + " and outputs: " + String.valueOf(outputSymbols));
        }
        return positions;
    }

    @Override
    public Void visitInputColumn(InputColumn inputColumn, Context context) {
        context.orderByPositions.add(inputColumn.index());
        return null;
    }

    @Override
    protected Void visitSymbol(Symbol symbol, Context context) {
        int idx = context.sourceSymbols.indexOf(symbol);
        if (idx >= 0) {
            context.orderByPositions.add(idx);
        }
        return null;
    }

    public static class Context {
        final List<? extends Symbol> sourceSymbols;
        IntArrayList orderByPositions;

        public Context(List<? extends Symbol> sourceSymbols) {
            this.sourceSymbols = sourceSymbols;
            this.orderByPositions = new IntArrayList();
        }

        public int[] orderByPositions() {
            return this.orderByPositions.toArray();
        }
    }
}

