/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Tuple;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class CreateAnalyzerPlan
implements Plan {
    private final AnalyzedCreateAnalyzer createAnalyzer;

    public CreateAnalyzerPlan(AnalyzedCreateAnalyzer createAnalyzer) {
        this.createAnalyzer = createAnalyzer;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ClusterUpdateSettingsRequest request = CreateAnalyzerPlan.createRequest(this.createAnalyzer, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, dependencies.fulltextAnalyzerResolver());
        dependencies.client().execute(ClusterUpdateSettingsAction.INSTANCE, request).whenComplete(new OneRowActionListener<ClusterUpdateSettingsResponse>(consumer, r -> new Row1((Object)1L)));
    }

    @VisibleForTesting
    public static ClusterUpdateSettingsRequest createRequest(AnalyzedCreateAnalyzer createAnalyzer, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, FulltextAnalyzerResolver ftResolver) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        String analyzerIdent = createAnalyzer.ident();
        Tuple<String, Settings> tokenizer = CreateAnalyzerPlan.bindTokenizer(createAnalyzer.tokenizer(), analyzerIdent, eval, ftResolver);
        Map<String, Settings> tokenFilters = CreateAnalyzerPlan.bindTokenFilters(createAnalyzer.tokenFilters(), analyzerIdent, eval, ftResolver);
        Map<String, Settings> charFilters = CreateAnalyzerPlan.bindCharFilters(createAnalyzer.charFilters(), analyzerIdent, eval, ftResolver);
        Settings genericAnalyzerSettings = CreateAnalyzerPlan.bindGenericAnalyzerProperties(createAnalyzer.genericAnalyzerProperties(), analyzerIdent, eval);
        Settings analyzerSettings = CreateAnalyzerPlan.buildAnalyzerSettings(analyzerIdent, createAnalyzer.extendedAnalyzerName(), tokenizer, tokenFilters, charFilters, genericAnalyzerSettings, ftResolver);
        Settings.Builder encodedSettingsBuilder = Settings.builder();
        encodedSettingsBuilder.put(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingName(analyzerIdent), FulltextAnalyzerResolver.encodeSettings(analyzerSettings).utf8ToString());
        if (tokenizer != null && !((Settings)tokenizer.v2()).isEmpty()) {
            encodedSettingsBuilder.put(FulltextAnalyzerResolver.CustomType.TOKENIZER.buildSettingName((String)tokenizer.v1()), FulltextAnalyzerResolver.encodeSettings((Settings)tokenizer.v2()).utf8ToString());
        }
        for (Map.Entry<String, Settings> tokenFilter : tokenFilters.entrySet()) {
            if (tokenFilter.getValue().isEmpty()) continue;
            encodedSettingsBuilder.put(FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.buildSettingName(tokenFilter.getKey()), FulltextAnalyzerResolver.encodeSettings(tokenFilter.getValue()).utf8ToString());
        }
        for (Map.Entry<String, Settings> charFilter : charFilters.entrySet()) {
            if (charFilter.getValue().isEmpty()) continue;
            encodedSettingsBuilder.put(FulltextAnalyzerResolver.CustomType.CHAR_FILTER.buildSettingName(charFilter.getKey()), FulltextAnalyzerResolver.encodeSettings(charFilter.getValue()).utf8ToString());
        }
        return new ClusterUpdateSettingsRequest().persistentSettings(encodedSettingsBuilder.build());
    }

    @Nullable
    private static Tuple<String, Settings> bindTokenizer(@Nullable Tuple<String, GenericProperties<Symbol>> tokenizer, String analyzerIdent, Function<? super Symbol, Object> eval, FulltextAnalyzerResolver ftResolver) {
        if (tokenizer == null) {
            return null;
        }
        String name = (String)tokenizer.v1();
        GenericProperties properties = (GenericProperties)tokenizer.v2();
        if (properties.isEmpty()) {
            if (!ftResolver.hasBuiltInTokenizer(name)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing tokenizer '%s'", name));
            }
            return new Tuple((Object)name, (Object)Settings.EMPTY);
        }
        if (!ftResolver.hasBuiltInTokenizer(name)) {
            String evaluatedType = CreateAnalyzerPlan.extractType((GenericProperties<Symbol>)properties, eval);
            if (!ftResolver.hasBuiltInTokenizer(evaluatedType)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing built-in tokenizer type '%s'", evaluatedType));
            }
        } else {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "tokenizer name '%s' is reserved", name));
        }
        name = String.format(Locale.ENGLISH, "%s_%s", analyzerIdent, name);
        Settings.Builder builder = Settings.builder();
        for (Map.Entry property : properties) {
            String settingName = FulltextAnalyzerResolver.CustomType.TOKENIZER.buildSettingChildName(name, (String)property.getKey());
            builder.putStringOrList(settingName, eval.apply((Symbol)property.getValue()));
        }
        return new Tuple((Object)name, (Object)builder.build());
    }

    private static Map<String, Settings> bindTokenFilters(Map<String, GenericProperties<Symbol>> tokenFilters, String analyzerIdent, Function<? super Symbol, Object> eval, FulltextAnalyzerResolver ftResolver) {
        HashMap<String, Settings> boundTokenFilters = HashMap.newHashMap(tokenFilters.size());
        for (Map.Entry<String, GenericProperties<Symbol>> tokenFilter : tokenFilters.entrySet()) {
            String name = tokenFilter.getKey();
            GenericProperties<Symbol> properties = tokenFilter.getValue();
            if (properties.isEmpty()) {
                if (!ftResolver.hasBuiltInTokenFilter(name)) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing built-in token-filter '%s'", name));
                }
                boundTokenFilters.put(name, Settings.EMPTY);
                continue;
            }
            Settings.Builder builder = Settings.builder();
            String fullName = analyzerIdent + "_" + name;
            if (!ftResolver.hasBuiltInTokenFilter(name)) {
                String evaluatedType = CreateAnalyzerPlan.extractType(properties, eval);
                if (!ftResolver.hasBuiltInTokenFilter(evaluatedType)) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing built-in token-filter type '%s'", evaluatedType));
                }
            } else {
                if (properties.get("type") != null) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "token-filter name '%s' is reserved, 'type' property forbidden here", name));
                }
                builder.put(FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.buildSettingChildName(fullName, "type"), name);
            }
            for (Map.Entry property : properties) {
                String settingName = FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.buildSettingChildName(fullName, (String)property.getKey());
                builder.putStringOrList(settingName, eval.apply((Symbol)property.getValue()));
            }
            boundTokenFilters.put(fullName, builder.build());
        }
        return boundTokenFilters;
    }

    private static Map<String, Settings> bindCharFilters(Map<String, GenericProperties<Symbol>> charFilters, String analyzerIdent, Function<? super Symbol, Object> eval, FulltextAnalyzerResolver ftResolver) {
        HashMap<String, Settings> boundedCharFilters = HashMap.newHashMap(charFilters.size());
        for (Map.Entry<String, GenericProperties<Symbol>> charFilter : charFilters.entrySet()) {
            String name = charFilter.getKey();
            GenericProperties<Symbol> properties = charFilter.getValue();
            if (properties.isEmpty()) {
                if (!ftResolver.hasBuiltInCharFilter(name)) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing built-in char-filter '%s'", name));
                }
                CreateAnalyzerPlan.validateCharFilterProperties(name, properties);
                boundedCharFilters.put(name, Settings.EMPTY);
                continue;
            }
            String type = CreateAnalyzerPlan.extractType(properties, eval);
            if (!ftResolver.hasBuiltInCharFilter(type)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Non-existing built-in char-filter type '%s'", type));
            }
            CreateAnalyzerPlan.validateCharFilterProperties(type, properties);
            name = String.format(Locale.ENGLISH, "%s_%s", analyzerIdent, name);
            Settings.Builder builder = Settings.builder();
            for (Map.Entry charFilterProperty : properties) {
                String settingName = FulltextAnalyzerResolver.CustomType.CHAR_FILTER.buildSettingChildName(name, (String)charFilterProperty.getKey());
                builder.putStringOrList(settingName, eval.apply((Symbol)charFilterProperty.getValue()));
            }
            boundedCharFilters.put(name, builder.build());
        }
        return boundedCharFilters;
    }

    private static Settings bindGenericAnalyzerProperties(GenericProperties<Symbol> properties, String analyzerIdent, Function<? super Symbol, Object> eval) {
        Settings.Builder builder = Settings.builder();
        for (Map.Entry property : properties) {
            String settingName = FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, (String)property.getKey());
            builder.putStringOrList(settingName, eval.apply((Symbol)property.getValue()));
        }
        return builder.build();
    }

    private static String extractType(GenericProperties<Symbol> properties, Function<? super Symbol, Object> eval) {
        Symbol type = (Symbol)properties.get("type");
        if (type == null) {
            throw new IllegalArgumentException("'type' property missing");
        }
        return (String)eval.apply(type);
    }

    private static void validateCharFilterProperties(String type, GenericProperties<?> properties) {
        if (properties.isEmpty() && !type.equals("html_strip")) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "CHAR_FILTER of type '%s' needs additional parameters", type));
        }
    }

    private static Settings buildAnalyzerSettings(String analyzerIdent, String extendedAnalyzerName, Tuple<String, Settings> tokenizer, Map<String, Settings> tokenFilters, Map<String, Settings> charFilters, Settings genericAnalyzerSettings, FulltextAnalyzerResolver ftResolver) {
        boolean extendsCustomAnalyzer;
        Settings extendedCustomAnalyzerSettings = ftResolver.getCustomAnalyzer(extendedAnalyzerName);
        Settings.Builder builder = Settings.builder();
        boolean bl = extendsCustomAnalyzer = extendedAnalyzerName != null && extendedCustomAnalyzerSettings != null && extendedCustomAnalyzerSettings.get(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, "type")).equals("custom");
        if (extendsCustomAnalyzer) {
            String extendedTokenizerName;
            Settings stripped = extendedCustomAnalyzerSettings.getByPrefix(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildNamePrefix(extendedAnalyzerName));
            for (String settingName : stripped.keySet()) {
                builder.put(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, settingName), stripped.get(settingName));
            }
            if (tokenizer == null && (extendedTokenizerName = extendedCustomAnalyzerSettings.get(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, FulltextAnalyzerResolver.CustomType.TOKENIZER.getName()))) != null) {
                Settings extendedTokenizerSettings = ftResolver.getCustomTokenizer(extendedTokenizerName);
                tokenizer = extendedTokenizerSettings != null ? new Tuple((Object)extendedTokenizerName, (Object)extendedTokenizerSettings) : new Tuple((Object)extendedTokenizerName, (Object)Settings.EMPTY);
            }
            if (tokenFilters.isEmpty()) {
                List<String> extendedTokenFilterNames = extendedCustomAnalyzerSettings.getAsList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.getName()));
                for (String extendedTokenFilterName : extendedTokenFilterNames) {
                    Settings extendedTokenFilterSettings = ftResolver.getCustomTokenFilter(extendedTokenFilterName);
                    if (extendedTokenFilterSettings != null) {
                        tokenFilters.put(extendedTokenFilterName, extendedTokenFilterSettings);
                        continue;
                    }
                    tokenFilters.put(extendedTokenFilterName, Settings.EMPTY);
                }
            }
            if (charFilters.isEmpty()) {
                List<String> extendedCustomCharFilterNames = extendedCustomAnalyzerSettings.getAsList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, FulltextAnalyzerResolver.CustomType.CHAR_FILTER.getName()));
                for (String extendedCustomCharFilterName : extendedCustomCharFilterNames) {
                    Settings extendedCustomCharFilterSettings = ftResolver.getCustomCharFilter(extendedCustomCharFilterName);
                    if (extendedCustomCharFilterSettings != null) {
                        charFilters.put(extendedCustomCharFilterName, extendedCustomCharFilterSettings);
                        continue;
                    }
                    charFilters.put(extendedCustomCharFilterName, Settings.EMPTY);
                }
            }
        } else if (CreateAnalyzerPlan.extendsBuiltInAnalyzer(extendedAnalyzerName, extendedCustomAnalyzerSettings) && genericAnalyzerSettings != null) {
            builder.put(genericAnalyzerSettings);
        }
        String analyzerType = "custom";
        if (CreateAnalyzerPlan.extendsBuiltInAnalyzer(extendedAnalyzerName, extendedCustomAnalyzerSettings)) {
            analyzerType = extendedCustomAnalyzerSettings != null ? extendedCustomAnalyzerSettings.get(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, "type")) : extendedAnalyzerName;
        }
        builder.put(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, "type"), analyzerType);
        if (tokenizer != null) {
            builder.put(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, FulltextAnalyzerResolver.CustomType.TOKENIZER.getName()), (String)tokenizer.v1());
        } else if (!CreateAnalyzerPlan.extendsBuiltInAnalyzer(extendedAnalyzerName, extendedCustomAnalyzerSettings)) {
            throw new UnsupportedOperationException("Tokenizer missing from non-extended analyzer");
        }
        if (!charFilters.isEmpty()) {
            String[] charFilterNames = charFilters.keySet().toArray(new String[0]);
            builder.putList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, FulltextAnalyzerResolver.CustomType.CHAR_FILTER.getName()), charFilterNames);
        }
        if (!tokenFilters.isEmpty()) {
            String[] tokenFilterNames = tokenFilters.keySet().toArray(new String[0]);
            builder.putList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerIdent, FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.getName()), tokenFilterNames);
        }
        return builder.build();
    }

    private static boolean extendsBuiltInAnalyzer(String extendedAnalyzerName, Settings extendedCustomAnalyzerSettings) {
        return extendedAnalyzerName != null && (extendedCustomAnalyzerSettings == null || !extendedCustomAnalyzerSettings.get(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(extendedAnalyzerName, "type")).equals("custom"));
    }
}

