/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.ddl.tables.DropPartitionsRequest;
import io.crate.execution.ddl.tables.TransportDropPartitionsAction;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.jetbrains.annotations.VisibleForTesting;

public class DeletePartitions
implements Plan {
    private final RelationName relationName;
    private final List<List<Symbol>> partitions;

    public DeletePartitions(RelationName relationName, List<List<Symbol>> partitions) {
        this.relationName = relationName;
        this.partitions = partitions;
    }

    @VisibleForTesting
    public List<List<Symbol>> partitions() {
        return this.partitions;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DELETE;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        List<PartitionName> partitionNames = this.getPartitions(this.relationName, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults);
        dependencies.client().execute(TransportDropPartitionsAction.ACTION, new DropPartitionsRequest(this.relationName, partitionNames)).whenComplete(new OneRowActionListener<AcknowledgedResponse>(consumer, ignoredResponse -> Row1.ROW_COUNT_UNKNOWN));
    }

    @VisibleForTesting
    List<PartitionName> getPartitions(RelationName relationName, TransactionContext txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        ArrayList<PartitionName> values = new ArrayList<PartitionName>();
        Function<Symbol, String> symbolToString = s -> DataTypes.STRING.implicitCast(SymbolEvaluator.evaluate(txnCtx, nodeCtx, s, parameters, subQueryResults));
        for (List<Symbol> partitionValues : this.partitions) {
            values.add(new PartitionName(relationName, Lists.map(partitionValues, symbolToString)));
        }
        return values;
    }
}

