/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedRefreshTable;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.refresh.TransportRefresh;

public class RefreshTablePlan
implements Plan {
    private final AnalyzedRefreshTable analysis;

    public RefreshTablePlan(AnalyzedRefreshTable analysis) {
        this.analysis = analysis;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        if (this.analysis.tables().isEmpty()) {
            consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
            return;
        }
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, parameters, subQueryResults);
        ArrayList<PartitionName> toRefresh = new ArrayList<PartitionName>();
        for (Map.Entry<Table<Symbol>, DocTableInfo> table : this.analysis.tables().entrySet()) {
            DocTableInfo tableInfo = table.getValue();
            Table<Symbol> tableSymbol = table.getKey();
            if (tableSymbol.partitionProperties().isEmpty()) {
                toRefresh.add(new PartitionName(tableInfo.ident(), List.of()));
                continue;
            }
            PartitionName partitionName = PartitionName.ofAssignments(tableInfo, Lists.map((Collection)tableSymbol.partitionProperties(), x -> x.map(eval)), plannerContext.clusterState().metadata());
            toRefresh.add(partitionName);
        }
        RefreshRequest request = new RefreshRequest(toRefresh);
        dependencies.client().execute(TransportRefresh.ACTION, request).whenComplete(new OneRowActionListener<RefreshResponse>(consumer, ignoredResponse -> new Row1((Object)(toRefresh.isEmpty() ? -1L : (long)toRefresh.size()))));
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }
}

