/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedResetStatement;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.CrateSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public final class ResetSettingsPlan
implements Plan {
    private final AnalyzedResetStatement resetAnalyzedStatement;

    public ResetSettingsPlan(AnalyzedResetStatement resetAnalyzedStatement) {
        this.resetAnalyzedStatement = resetAnalyzedStatement;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        Settings settings = ResetSettingsPlan.buildSettingsFrom(this.resetAnalyzedStatement.settingsToRemove(), eval);
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest().persistentSettings(settings).transientSettings(settings);
        OneRowActionListener<ClusterUpdateSettingsResponse> actionListener = new OneRowActionListener<ClusterUpdateSettingsResponse>(consumer, r -> r.isAcknowledged() ? new Row1((Object)1L) : new Row1((Object)0L));
        dependencies.client().execute(ClusterUpdateSettingsAction.INSTANCE, request).whenComplete(actionListener);
    }

    @VisibleForTesting
    static Settings buildSettingsFrom(Set<Symbol> settings, Function<? super Symbol, Object> eval) {
        Settings.Builder settingsBuilder = Settings.builder();
        for (Symbol symbol : settings) {
            String settingsName = eval.apply(symbol).toString();
            List<String> settingNames = CrateSettings.settingNamesByPrefix(settingsName);
            if (settingNames.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Setting '%s' is not supported", settingsName));
            }
            for (String name : settingNames) {
                CrateSettings.checkIfRuntimeSetting(name);
                if (!CrateSettings.isValidSetting(name)) {
                    throw new IllegalArgumentException("Setting '" + String.valueOf(settingNames) + "' is not supported");
                }
                settingsBuilder.put(name, (String)null);
            }
        }
        return settingsBuilder.build();
    }
}

