/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.CrateSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Assignment;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public final class UpdateSettingsPlan
implements Plan {
    private final Collection<Assignment<Symbol>> settings;
    private final boolean isPersistent;

    public UpdateSettingsPlan(Collection<Assignment<Symbol>> settings, boolean isPersistent) {
        this.settings = settings;
        this.isPersistent = isPersistent;
    }

    @VisibleForTesting
    public Collection<Assignment<Symbol>> settings() {
        return this.settings;
    }

    @VisibleForTesting
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        ClusterUpdateSettingsRequest request = this.isPersistent ? new ClusterUpdateSettingsRequest().persistentSettings(UpdateSettingsPlan.buildSettingsFrom(this.settings, eval)) : new ClusterUpdateSettingsRequest().transientSettings(UpdateSettingsPlan.buildSettingsFrom(this.settings, eval));
        OneRowActionListener<ClusterUpdateSettingsResponse> actionListener = new OneRowActionListener<ClusterUpdateSettingsResponse>(consumer, r -> r.isAcknowledged() ? new Row1((Object)1L) : new Row1((Object)0L));
        dependencies.client().execute(ClusterUpdateSettingsAction.INSTANCE, request).whenComplete(actionListener);
    }

    @VisibleForTesting
    static Settings buildSettingsFrom(Collection<Assignment<Symbol>> assignments, Function<? super Symbol, Object> eval) {
        Settings.Builder settingsBuilder = Settings.builder();
        for (Assignment<Symbol> entry : assignments) {
            String settingsName = eval.apply((Symbol)entry.columnName()).toString();
            if (!CrateSettings.isValidSetting(settingsName)) {
                throw new IllegalArgumentException("Setting '" + settingsName + "' is not supported");
            }
            Symbol expression = (Symbol)Lists.getOnlyElement((List)entry.expressions());
            Object value = eval.apply(expression);
            CrateSettings.flattenSettings(settingsBuilder, settingsName, value);
        }
        Settings settings = settingsBuilder.build();
        for (String checkForRuntime : settings.keySet()) {
            CrateSettings.checkIfRuntimeSetting(checkForRuntime);
        }
        return settings;
    }
}

