/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.management;

import io.crate.analyze.BoundCopyFrom;
import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.common.collections.MapBuilder;
import io.crate.data.CollectingRowConsumer;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.data.SentinelRow;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.MultiPhaseExecutor;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.NodeOperationGrouper;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.engine.profile.CollectProfileNodeAction;
import io.crate.execution.engine.profile.CollectProfileRequest;
import io.crate.execution.engine.profile.NodeCollectProfileResponse;
import io.crate.execution.engine.profile.TransportCollectProfileOperation;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlanPrinter;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.management.OptimizerStep;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.symbol.Optimizer;
import io.crate.planner.statement.CopyFromPlan;
import io.crate.profile.ProfilingContext;
import io.crate.profile.Timer;
import io.crate.session.BaseResultReceiver;
import io.crate.session.RowConsumerToResultReceiver;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ExplainPlan
implements Plan {
    private static final CastOptimizer CAST_OPTIMIZER = new CastOptimizer();
    private final Plan subPlan;
    @Nullable
    private final ProfilingContext context;
    private final boolean showCosts;
    private final boolean verbose;
    private final List<OptimizerStep> optimizerSteps;

    public ExplainPlan(Plan subExecutionPlan, boolean showCosts, @Nullable ProfilingContext context, boolean verbose, List<OptimizerStep> optimizerSteps) {
        this.subPlan = subExecutionPlan;
        this.context = context;
        this.showCosts = showCosts;
        this.verbose = verbose;
        this.optimizerSteps = optimizerSteps;
    }

    public Plan subPlan() {
        return this.subPlan;
    }

    public boolean showCosts() {
        return this.showCosts;
    }

    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Object planAsString;
        if (this.context != null) {
            assert (this.subPlan instanceof LogicalPlan) : "subPlan must be a LogicalPlan";
            LogicalPlan plan = (LogicalPlan)this.subPlan;
            this.executePlan(plan, dependencies, plannerContext, consumer, params, subQueryResults, new IdentityHashMap<SelectSymbol, Object>(), new ArrayList<Map<String, Object>>(plan.dependencies().size()), null, null);
            return;
        }
        Plan plan = this.subPlan;
        if (plan instanceof LogicalPlan) {
            LogicalPlan logicalPlan = (LogicalPlan)plan;
            if (this.verbose) {
                List rows = this.optimizerSteps.stream().map(step -> {
                    if (step.isInitial()) {
                        return new RowN(new Object[]{"Initial logical plan", step.planAsString()});
                    }
                    return new RowN(new Object[]{step.rule().sessionSettingName(), step.planAsString()});
                }).collect(Collectors.toCollection(ArrayList::new));
                rows.add(new RowN(new Object[]{"Final logical plan", ExplainPlan.printLogicalPlan(logicalPlan, plannerContext, this.showCosts)}));
                consumer.accept(InMemoryBatchIterator.of((Iterable)rows, (Object)SentinelRow.SENTINEL, (boolean)false), null);
                return;
            }
            planAsString = ExplainPlan.printLogicalPlan(logicalPlan, plannerContext, this.showCosts);
            consumer.accept(InMemoryBatchIterator.of((Object)new Row1(planAsString), (Object)SentinelRow.SENTINEL), null);
            return;
        }
        planAsString = this.subPlan;
        if (planAsString instanceof CopyFromPlan) {
            CopyFromPlan copyFromPlan = (CopyFromPlan)planAsString;
            if (!this.verbose) {
                BoundCopyFrom boundCopyFrom = CopyFromPlan.bind(copyFromPlan.copyFrom(), plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
                ExecutionPlan executionPlan = CopyFromPlan.planCopyFromExecution(copyFromPlan.copyFrom(), boundCopyFrom, dependencies.clusterService().state().nodes(), plannerContext);
                String planAsJson = DataTypes.STRING.implicitCast(PlanPrinter.objectMap(executionPlan));
                consumer.accept(InMemoryBatchIterator.of((Object)new Row1((Object)planAsJson), (Object)SentinelRow.SENTINEL), null);
                return;
            }
        }
        if (this.verbose) {
            consumer.accept(null, (Throwable)new UnsupportedOperationException("EXPLAIN VERBOSE not supported for " + this.subPlan.getClass().getSimpleName()));
            return;
        }
        consumer.accept(InMemoryBatchIterator.of((Object)new Row1((Object)("EXPLAIN not supported for " + this.subPlan.getClass().getSimpleName())), (Object)SentinelRow.SENTINEL), null);
    }

    private CompletableFuture<?> executeTopLevelPlan(LogicalPlan plan, DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, List<Map<String, Object>> subQueryExplainResults) {
        assert (this.context != null) : "profilingContext must NOT be null when executing plans";
        Timer timer = this.context.createTimer(Phase.Execute.name());
        timer.start();
        BaseResultReceiver resultReceiver = new BaseResultReceiver();
        RowConsumerToResultReceiver noopRowConsumer = new RowConsumerToResultReceiver(resultReceiver, 0, t -> {});
        NodeOperationTree operationTree = null;
        try {
            operationTree = LogicalPlanner.getNodeOperationTree(plan, executor, plannerContext, params, subQueryResults);
        }
        catch (Throwable e) {
            consumer.accept(null, e);
        }
        resultReceiver.completionFuture().whenComplete((BiConsumer)this.createResultConsumer(executor, consumer, plannerContext.jobId(), timer, operationTree, subQueryExplainResults));
        LogicalPlanner.executeNodeOpTree(executor, plannerContext.transactionContext(), plannerContext.jobId(), noopRowConsumer, true, operationTree);
        return consumer.completionFuture();
    }

    private CompletableFuture<?> executePlan(LogicalPlan plan, DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, Map<SelectSymbol, Object> valuesBySubQuery, List<Map<String, Object>> explainResults, @Nullable RamAccounting ramAccounting, @Nullable SelectSymbol selectSymbol) {
        boolean isTopLevel;
        boolean bl = isTopLevel = selectSymbol == null;
        assert (ramAccounting != null || isTopLevel) : "ramAccounting must NOT be null for subPlans";
        if (ramAccounting == null) {
            ramAccounting = ConcurrentRamAccounting.forCircuitBreaker("multi-phase", executor.circuitBreaker("query"), plannerContext.transactionContext().sessionSettings().memoryLimitInBytes());
        }
        if (!isTopLevel) {
            plannerContext = PlannerContext.forSubPlan(plannerContext);
        }
        IdentityHashMap<SelectSymbol, Object> subPlanValueBySubQuery = new IdentityHashMap<SelectSymbol, Object>();
        ArrayList<Map<String, Object>> subPlansExplainResults = new ArrayList<Map<String, Object>>(plan.dependencies().size());
        ArrayList subPlansFutures = new ArrayList(plan.dependencies().size());
        for (Map.Entry<LogicalPlan, SelectSymbol> entry : plan.dependencies().entrySet()) {
            SelectSymbol subPlanSelectSymbol = entry.getValue();
            LogicalPlan subPlan = plannerContext.optimize().apply(entry.getKey(), plannerContext);
            subPlansFutures.add(this.executePlan(subPlan, executor, PlannerContext.forSubPlan(plannerContext), consumer, params, subQueryResults, subPlanValueBySubQuery, subPlansExplainResults, ramAccounting, subPlanSelectSymbol));
        }
        CompletableFuture<Void> subPlansFuture = CompletableFuture.allOf(subPlansFutures.toArray(new CompletableFuture[0]));
        PlannerContext plannerContextFinal = plannerContext;
        if (isTopLevel) {
            return subPlansFuture.thenCompose(ignored -> this.executeTopLevelPlan(plan, executor, plannerContextFinal, consumer, params, SubQueryResults.merge(subQueryResults, new SubQueryResults(subPlanValueBySubQuery)), subPlansExplainResults));
        }
        RamAccounting ramAccountingFinal = ramAccounting;
        return subPlansFuture.thenCompose(ignored -> this.executeSingleSubPlan(plan, selectSymbol, executor, plannerContextFinal, ramAccountingFinal, params, SubQueryResults.merge(subQueryResults, new SubQueryResults(subPlanValueBySubQuery)), subPlansExplainResults).thenCompose(subQueryResultAndExplain -> {
            Object object = valuesBySubQuery;
            synchronized (object) {
                valuesBySubQuery.put(selectSymbol, subQueryResultAndExplain.value());
            }
            object = explainResults;
            synchronized (object) {
                explainResults.add(subQueryResultAndExplain.explainResult());
            }
            return CompletableFuture.completedFuture(null);
        }));
    }

    private CompletableFuture<SubQueryResultAndExplain> executeSingleSubPlan(LogicalPlan plan, SelectSymbol selectSymbol, DependencyCarrier executor, PlannerContext plannerContext, RamAccounting ramAccounting, Row params, SubQueryResults subQueryResults, List<Map<String, Object>> explainResults) {
        CollectingRowConsumer<?, ?> rowConsumer = MultiPhaseExecutor.getConsumer(selectSymbol, ramAccounting);
        ProfilingContext subPlanContext = new ProfilingContext(Map.of());
        Timer subPlanTimer = subPlanContext.createTimer(Phase.Execute.name());
        subPlanTimer.start();
        NodeOperationTree operationTree = LogicalPlanner.getNodeOperationTree(plan, executor, plannerContext, params, subQueryResults);
        LogicalPlanner.executeNodeOpTree(executor, plannerContext.transactionContext(), plannerContext.jobId(), rowConsumer, true, operationTree);
        return rowConsumer.completionFuture().thenCompose(val -> {
            subPlanContext.stopTimerAndStoreDuration(subPlanTimer);
            return this.collectTimingResults(plannerContext.jobId(), executor, operationTree.nodeOperations()).thenCompose(timingResults -> {
                Map<String, Object> explainOutput = this.buildResponse(subPlanContext.getDurationInMSByTimer(), (Map<String, Map<String, Object>>)timingResults, operationTree, explainResults, true);
                return CompletableFuture.completedFuture(new SubQueryResultAndExplain(val, explainOutput));
            });
        });
    }

    @VisibleForTesting
    public static String printLogicalPlan(LogicalPlan logicalPlan, PlannerContext plannerContext, boolean showCosts) {
        PrintContext printContext = ExplainPlan.createPrintContext(plannerContext.planStats(), showCosts);
        LogicalPlan optimizedLogicalPlan = logicalPlan.accept(CAST_OPTIMIZER, plannerContext);
        optimizedLogicalPlan.print(printContext);
        return printContext.toString();
    }

    public static PrintContext createPrintContext(PlanStats planStats, boolean showCosts) {
        if (showCosts) {
            return new PrintContext(planStats);
        }
        return new PrintContext(null);
    }

    private BiConsumer<Void, Throwable> createResultConsumer(DependencyCarrier executor, RowConsumer consumer, UUID jobId, Timer timer, NodeOperationTree operationTree, List<Map<String, Object>> subQueryExplainResults) {
        assert (this.context != null) : "profilingContext must be available if createResultconsumer is used";
        return (ignored, t) -> {
            this.context.stopTimerAndStoreDuration(timer);
            if (t == null) {
                OneRowActionListener<Map> actionListener = new OneRowActionListener<Map>(consumer, resp -> new Row1(this.buildResponse(this.context.getDurationInMSByTimer(), (Map<String, Map<String, Object>>)resp, operationTree, subQueryExplainResults, false)));
                this.collectTimingResults(jobId, executor, operationTree.nodeOperations()).whenComplete(actionListener);
            } else {
                consumer.accept(null, t);
            }
        };
    }

    private TransportCollectProfileOperation getCollectOperation(DependencyCarrier executor, UUID jobId) {
        ActionExecutor<NodeRequest<CollectProfileRequest>, NodeCollectProfileResponse> nodeAction = req -> executor.client().execute(CollectProfileNodeAction.INSTANCE, req);
        return new TransportCollectProfileOperation(nodeAction, jobId);
    }

    private Map<String, Object> buildResponse(Map<String, Object> apeTimings, Map<String, Map<String, Object>> timingsByNodeId, NodeOperationTree operationTree, List<Map<String, Object>> subQueryExplainResults, boolean isSubQuery) {
        MapBuilder mapBuilder = MapBuilder.newMapBuilder();
        if (!isSubQuery) {
            apeTimings.forEach((arg_0, arg_1) -> ((MapBuilder)mapBuilder).put(arg_0, arg_1));
        }
        Map<String, Object> phasesTimings = ExplainPlan.extractPhasesTimingsFrom(timingsByNodeId, operationTree);
        Map<String, Map<String, Object>> resultNodeTimings = ExplainPlan.getNodeTimingsWithoutPhases(phasesTimings.keySet(), timingsByNodeId);
        MapBuilder executionTimingsMap = MapBuilder.newMapBuilder();
        executionTimingsMap.put((Object)"Phases", phasesTimings);
        resultNodeTimings.forEach((arg_0, arg_1) -> ((MapBuilder)executionTimingsMap).put(arg_0, arg_1));
        executionTimingsMap.put((Object)"Total", apeTimings.get(Phase.Execute.name()));
        if (!subQueryExplainResults.isEmpty()) {
            ArrayList<Object> subQueryExplainResultsList = new ArrayList<Object>(subQueryExplainResults.size());
            for (Map<String, Object> subQueryExplainResult : subQueryExplainResults) {
                subQueryExplainResultsList.add(subQueryExplainResult.get(Phase.Execute.name()));
            }
            executionTimingsMap.put((Object)"Sub-Queries", subQueryExplainResultsList);
        }
        mapBuilder.put((Object)Phase.Execute.name(), (Object)executionTimingsMap.immutableMap());
        return mapBuilder.immutableMap();
    }

    private static Map<String, Object> extractPhasesTimingsFrom(Map<String, Map<String, Object>> timingsByNodeId, NodeOperationTree operationTree) {
        TreeMap<String, Object> allPhases = new TreeMap<String, Object>();
        for (NodeOperation operation : operationTree.nodeOperations()) {
            ExecutionPhase phase = operation.executionPhase();
            ExplainPlan.getPhaseTimingsAndAddThemToPhasesMap(phase, timingsByNodeId, allPhases);
        }
        ExecutionPhase leafExecutionPhase = operationTree.leaf();
        ExplainPlan.getPhaseTimingsAndAddThemToPhasesMap(leafExecutionPhase, timingsByNodeId, allPhases);
        return allPhases;
    }

    private static void getPhaseTimingsAndAddThemToPhasesMap(ExecutionPhase leafExecutionPhase, Map<String, Map<String, Object>> timingsByNodeId, Map<String, Object> allPhases) {
        String phaseName = ProfilingContext.generateProfilingKey(leafExecutionPhase.phaseId(), leafExecutionPhase.name());
        Map<String, Object> phaseTimingsAcrossNodes = ExplainPlan.getPhaseTimingsAcrossNodes(phaseName, timingsByNodeId);
        if (!phaseTimingsAcrossNodes.isEmpty()) {
            allPhases.put(phaseName, Map.of("nodes", phaseTimingsAcrossNodes));
        }
    }

    private static Map<String, Object> getPhaseTimingsAcrossNodes(String phaseName, Map<String, Map<String, Object>> timingsByNodeId) {
        HashMap<String, Object> timingsForPhaseAcrossNodes = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Object>> nodeToTimingsEntry : timingsByNodeId.entrySet()) {
            Object phaseTiming;
            Map<String, Object> timingsForNode = nodeToTimingsEntry.getValue();
            if (timingsForNode == null || (phaseTiming = timingsForNode.get(phaseName)) == null) continue;
            String node = nodeToTimingsEntry.getKey();
            timingsForPhaseAcrossNodes.put(node, phaseTiming);
        }
        return Collections.unmodifiableMap(timingsForPhaseAcrossNodes);
    }

    private static Map<String, Map<String, Object>> getNodeTimingsWithoutPhases(Set<String> phasesNames, Map<String, Map<String, Object>> timingsByNodeId) {
        HashMap<String, HashMap<String, Object>> nodeTimingsWithoutPhases = HashMap.newHashMap(timingsByNodeId.size());
        for (Map.Entry<String, Map<String, Object>> nodeToTimingsEntry : timingsByNodeId.entrySet()) {
            nodeTimingsWithoutPhases.put(nodeToTimingsEntry.getKey(), new HashMap<String, Object>(nodeToTimingsEntry.getValue()));
        }
        for (Map timings : nodeTimingsWithoutPhases.values()) {
            for (String phaseToRemove : phasesNames) {
                timings.remove(phaseToRemove);
            }
        }
        return Collections.unmodifiableMap(nodeTimingsWithoutPhases);
    }

    private CompletableFuture<Map<String, Map<String, Object>>> collectTimingResults(UUID jobId, DependencyCarrier executor, Collection<NodeOperation> nodeOperations) {
        HashSet<String> nodeIds = new HashSet<String>(NodeOperationGrouper.groupByServer(nodeOperations).keySet());
        nodeIds.add(executor.localNodeId());
        CompletableFuture<Map<String, Map<String, Object>>> resultFuture = new CompletableFuture<Map<String, Map<String, Object>>>();
        TransportCollectProfileOperation collectOperation = this.getCollectOperation(executor, jobId);
        ConcurrentHashMap<String, Map<String, Object>> timingsByNodeId = new ConcurrentHashMap<String, Map<String, Object>>(nodeIds.size());
        AtomicInteger remainingCollectOps = new AtomicInteger(nodeIds.size());
        for (String nodeId : nodeIds) {
            collectOperation.collect(nodeId).whenComplete((BiConsumer)ExplainPlan.mergeResultsAndCompleteFuture(resultFuture, timingsByNodeId, remainingCollectOps, nodeId));
        }
        return resultFuture;
    }

    private static BiConsumer<Map<String, Object>, Throwable> mergeResultsAndCompleteFuture(CompletableFuture<Map<String, Map<String, Object>>> resultFuture, ConcurrentHashMap<String, Map<String, Object>> timingsByNodeId, AtomicInteger remainingOperations, String nodeId) {
        return (map, throwable) -> {
            if (throwable == null) {
                timingsByNodeId.put(nodeId, (Map<String, Object>)map);
                if (remainingOperations.decrementAndGet() == 0) {
                    resultFuture.complete(timingsByNodeId);
                }
            } else {
                resultFuture.completeExceptionally((Throwable)throwable);
            }
        };
    }

    @VisibleForTesting
    public boolean doAnalyze() {
        return this.context != null;
    }

    public static enum Phase {
        Analyze,
        Plan,
        Execute;

    }

    private static class CastOptimizer
    extends LogicalPlanVisitor<PlannerContext, LogicalPlan> {
        private CastOptimizer() {
        }

        @Override
        public LogicalPlan visitPlan(LogicalPlan logicalPlan, PlannerContext context) {
            ArrayList<LogicalPlan> newSources = new ArrayList<LogicalPlan>(logicalPlan.sources().size());
            for (LogicalPlan source : logicalPlan.sources()) {
                newSources.add(source.accept(this, context));
            }
            return logicalPlan.replaceSources(newSources);
        }

        @Override
        public LogicalPlan visitCollect(Collect collect, PlannerContext context) {
            Collect optimizedCollect = new Collect(collect.relation(), collect.outputs(), collect.where().map(s -> Optimizer.optimizeCasts(s, context)));
            return this.visitPlan((LogicalPlan)optimizedCollect, context);
        }
    }

    record SubQueryResultAndExplain(Object value, Map<String, Object> explainResult) {
    }
}

