/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.ProjectSetProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.FunctionType;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ProjectSet
extends ForwardingLogicalPlan {
    final List<Function> tableFunctions;
    final List<Symbol> standalone;
    private final List<Symbol> outputs;

    static LogicalPlan create(LogicalPlan source, List<Function> tableFunctions) {
        List<Function> childTableFunctions;
        if (tableFunctions.isEmpty()) {
            return source;
        }
        ArrayList<List<Function>> nestedFunctions = new ArrayList<List<Function>>();
        nestedFunctions.add(tableFunctions);
        while (!(childTableFunctions = tableFunctions.stream().flatMap(func -> func.arguments().stream()).filter(arg -> {
            Function fn;
            return arg instanceof Function && (fn = (Function)arg).signature().getType() == FunctionType.TABLE;
        }).map(x -> (Function)x).toList()).isEmpty()) {
            nestedFunctions.add(childTableFunctions);
            tableFunctions = childTableFunctions;
        }
        LogicalPlan result = source;
        for (int i = nestedFunctions.size() - 1; i >= 0; --i) {
            List<Symbol> standalone = result.outputs().stream().filter(x -> {
                Function fn;
                return !(x instanceof Function && (fn = (Function)x).signature().getType() == FunctionType.TABLE);
            }).toList();
            result = new ProjectSet(result, (List)nestedFunctions.get(i), standalone);
        }
        return result;
    }

    private ProjectSet(LogicalPlan source, List<Function> tableFunctions, List<Symbol> standalone) {
        super(source);
        this.outputs = Lists.concat(tableFunctions, standalone);
        this.tableFunctions = tableFunctions;
        this.standalone = standalone;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan sourcePlan = this.source.build(executor, plannerContext, planHints, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(this.source.outputs());
        List<Symbol> tableFunctionsWithInputs = InputColumns.create(Lists.map(this.tableFunctions, (java.util.function.Function)paramBinder), sourceSymbols);
        List<Symbol> standaloneWithInputs = InputColumns.create(this.standalone, sourceSymbols);
        sourcePlan.addProjection(new ProjectSetProjection(tableFunctionsWithInputs, standaloneWithInputs));
        return sourcePlan;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public List<Symbol> standaloneOutputs() {
        return this.standalone;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> toKeep = new LinkedHashSet<Symbol>();
        LinkedHashSet newStandalone = new LinkedHashSet();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.standalone, newStandalone::add);
        }
        for (Function tableFunction : this.tableFunctions) {
            Symbols.intersection(tableFunction, this.source.outputs(), toKeep::add);
        }
        toKeep.addAll(newStandalone);
        LogicalPlan newSource = this.source.pruneOutputsExcept(toKeep);
        if (newSource == this.source) {
            return this;
        }
        return new ProjectSet(newSource, this.tableFunctions, List.copyOf(newStandalone));
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new ProjectSet((LogicalPlan)Lists.getOnlyElement(sources), this.tableFunctions, this.standalone);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitProjectSet(this, context);
    }
}

