/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.planner.Plan;
import io.crate.planner.operators.Insert;
import io.crate.planner.operators.InsertFromValues;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.MultiPhase;
import io.crate.planner.operators.Rename;
import io.crate.planner.operators.RootRelationBoundary;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public final class StatementClassifier
extends LogicalPlanVisitor<Set<String>, Void> {
    private static final StatementClassifier INSTANCE = new StatementClassifier();

    private StatementClassifier() {
    }

    public static Classification classify(Plan plan) {
        if (plan instanceof LogicalPlan) {
            TreeSet<String> classes = new TreeSet<String>();
            ((LogicalPlan)plan).accept(INSTANCE, classes);
            return new Classification(plan.type(), classes);
        }
        return new Classification(plan.type());
    }

    @Override
    public Void visitPlan(LogicalPlan logicalPlan, Set<String> context) {
        for (LogicalPlan source : logicalPlan.sources()) {
            source.accept(this, context);
        }
        context.add(logicalPlan.getClass().getSimpleName());
        return null;
    }

    @Override
    public Void visitRootRelationBoundary(RootRelationBoundary logicalPlan, Set<String> context) {
        logicalPlan.source.accept(this, context);
        return null;
    }

    @Override
    public Void visitInsert(Insert logicalPlan, Set<String> context) {
        logicalPlan.source.accept(this, context);
        return null;
    }

    @Override
    public Void visitRename(Rename rename, Set<String> context) {
        rename.source.accept(this, context);
        return null;
    }

    @Override
    public Void visitInsert(InsertFromValues logicalPlan, Set<String> context) {
        return this.visitPlan((LogicalPlan)logicalPlan, context);
    }

    @Override
    public Void visitMultiPhase(MultiPhase logicalPlan, Set<String> context) {
        for (LogicalPlan plan : logicalPlan.dependencies().keySet()) {
            plan.accept(this, context);
        }
        return this.visitPlan((LogicalPlan)logicalPlan, context);
    }

    public static class Classification {
        private final Set<String> labels;
        private final Plan.StatementType type;

        public Classification(Plan.StatementType type, Set<String> labels) {
            this.type = type;
            this.labels = labels;
        }

        public Classification(Plan.StatementType type) {
            this.type = type;
            this.labels = Collections.emptySet();
        }

        public Set<String> labels() {
            return this.labels;
        }

        public Plan.StatementType type() {
            return this.type;
        }

        public String toString() {
            return "Classification{type=" + String.valueOf((Object)this.type) + ", labels=" + String.valueOf(this.labels) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Classification that = (Classification)o;
            return Objects.equals(this.labels, that.labels) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.labels, this.type});
        }
    }
}

