/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.common.collections.Maps;
import io.crate.common.collections.Sets;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.UnionExecutionPlan;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Union
implements LogicalPlan {
    private final List<Symbol> outputs;
    final LogicalPlan lhs;
    final LogicalPlan rhs;

    public Union(LogicalPlan lhs, LogicalPlan rhs, List<Symbol> outputs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.outputs = outputs;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        Integer childPageSizeHint = limit != -1 ? Integer.valueOf(Limit.limitAndOffset(limit, offset)) : null;
        ExecutionPlan left = this.lhs.build(executor, plannerContext, hints, projectionBuilder, limit + offset, 0, null, childPageSizeHint, params, subQueryResults);
        ExecutionPlan right = this.rhs.build(executor, plannerContext, hints, projectionBuilder, limit + offset, 0, null, childPageSizeHint, params, subQueryResults);
        this.addCastsForIncompatibleObjects(this.lhs, left);
        this.addCastsForIncompatibleObjects(this.rhs, right);
        if (left.resultDescription().hasRemainingLimitOrOffset()) {
            left = Merge.ensureOnHandler(left, plannerContext);
        }
        if (right.resultDescription().hasRemainingLimitOrOffset()) {
            right = Merge.ensureOnHandler(right, plannerContext);
        }
        ResultDescription leftResultDesc = left.resultDescription();
        ResultDescription rightResultDesc = right.resultDescription();
        assert (DataTypes.isCompatibleType(leftResultDesc.streamOutputs(), rightResultDesc.streamOutputs())) : "Left and right must output the same types, got lhs=" + String.valueOf(leftResultDesc.streamOutputs()) + ", rhs=" + String.valueOf(rightResultDesc.streamOutputs());
        Set upstreamNodes = Sets.union(leftResultDesc.nodeIds(), rightResultDesc.nodeIds());
        MergePhase mergePhase = new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), "union", leftResultDesc.nodeIds().size() + rightResultDesc.nodeIds().size(), 2, Collections.singletonList(plannerContext.handlerNode()), leftResultDesc.streamOutputs(), Collections.emptyList(), upstreamNodes, DistributionInfo.DEFAULT_BROADCAST, leftResultDesc.orderBy());
        return new UnionExecutionPlan(left, right, mergePhase, -1, 0, this.lhs.outputs().size(), -1, leftResultDesc.orderBy());
    }

    private void addCastsForIncompatibleObjects(LogicalPlan logicalPlan, ExecutionPlan executionPlan) {
        EvalProjection castValues = EvalProjection.castValues(Symbols.typeView(this.outputs), logicalPlan.outputs());
        if (castValues != null) {
            executionPlan.addProjection(castValues);
        }
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<RelationName> relationNames() {
        return Lists.concatUnique(this.lhs.relationNames(), this.rhs.relationNames());
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.lhs, this.rhs);
    }

    @Override
    public boolean supportsDistributedReads() {
        return this.lhs.supportsDistributedReads() && this.rhs.supportsDistributedReads();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Union(sources.get(0), sources.get(1), this.outputs);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        IntArrayList outputIndicesToKeep = new IntArrayList();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.outputs, s -> {
                for (int i = 0; i < this.outputs.size(); ++i) {
                    Symbol output = this.outputs.get(i);
                    if (!output.equals(s) || outputIndicesToKeep.contains(i)) continue;
                    outputIndicesToKeep.add(i);
                }
            });
        }
        ArrayList<Symbol> toKeepFromLhs = new ArrayList<Symbol>();
        ArrayList<Symbol> toKeepFromRhs = new ArrayList<Symbol>();
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (IntCursor cursor : outputIndicesToKeep) {
            toKeepFromLhs.add(this.lhs.outputs().get(cursor.value));
            toKeepFromRhs.add(this.rhs.outputs().get(cursor.value));
            newOutputs.add(this.outputs.get(cursor.value));
        }
        LogicalPlan newLhs = this.lhs.pruneOutputsExcept(toKeepFromLhs);
        LogicalPlan newRhs = this.rhs.pruneOutputsExcept(toKeepFromRhs);
        if (newLhs == this.lhs && newRhs == this.rhs) {
            return this;
        }
        return new Union(newLhs, newRhs, newOutputs);
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Maps.concat(this.lhs.dependencies(), this.rhs.dependencies());
    }

    public LogicalPlan lhs() {
        return this.lhs;
    }

    public LogicalPlan rhs() {
        return this.rhs;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitUnion(this, context);
    }
}

