/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer;

import io.crate.common.collections.Lists;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import io.crate.session.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.Version;
import org.jetbrains.annotations.Nullable;

public class Optimizer {
    private final List<Rule<?>> rules;
    private final Supplier<Version> minNodeVersionInCluster;
    private final NodeContext nodeCtx;

    public Optimizer(NodeContext nodeCtx, Supplier<Version> minNodeVersionInCluster, List<Rule<?>> rules) {
        this.rules = rules;
        this.minNodeVersionInCluster = minNodeVersionInCluster;
        this.nodeCtx = nodeCtx;
    }

    public LogicalPlan optimize(LogicalPlan plan, PlanStats planStats, CoordinatorTxnCtx txnCtx, OptimizerTracer tracer, Session.TimeoutToken timeoutToken) {
        List<Rule<?>> applicableRules;
        LogicalPlan optimizedRoot = this.tryApplyRules(applicableRules = Optimizer.removeExcludedRules(this.rules, txnCtx.sessionSettings().excludedOptimizerRules()), plan, planStats, txnCtx, tracer, timeoutToken);
        List optimizedSources = Lists.mapIfChange(optimizedRoot.sources(), x -> this.optimize((LogicalPlan)x, planStats, txnCtx, tracer, timeoutToken));
        return this.tryApplyRules(applicableRules, optimizedSources == optimizedRoot.sources() ? optimizedRoot : optimizedRoot.replaceSources(optimizedSources), planStats, txnCtx, tracer, timeoutToken);
    }

    public static List<Rule<?>> removeExcludedRules(List<Rule<?>> rules, Set<Class<? extends Rule<?>>> excludedRules) {
        if (excludedRules.isEmpty()) {
            return rules;
        }
        ArrayList result = new ArrayList(rules.size());
        for (Rule<?> rule : rules) {
            if (!rule.mandatory() && excludedRules.contains(rule.getClass())) continue;
            result.add(rule);
        }
        return result;
    }

    private LogicalPlan tryApplyRules(List<Rule<?>> rules, LogicalPlan plan, PlanStats planStats, TransactionContext txnCtx, OptimizerTracer tracer, Session.TimeoutToken timeoutToken) {
        int numIterations;
        LogicalPlan node = plan;
        boolean done = false;
        Rule.Context ruleContext = new Rule.Context(planStats, txnCtx, this.nodeCtx, UnaryOperator.identity(), timeoutToken);
        Version minVersion = this.minNodeVersionInCluster.get();
        for (numIterations = 0; !done && numIterations < 10000; ++numIterations) {
            if (numIterations % 100 == 0) {
                timeoutToken.check();
            }
            done = true;
            for (Rule<?> rule : rules) {
                LogicalPlan transformedPlan;
                if (minVersion.before(rule.requiredVersion()) || (transformedPlan = Optimizer.tryMatchAndApply(rule, node, ruleContext, tracer)) == null) continue;
                tracer.ruleApplied(rule, transformedPlan, ruleContext.planStats());
                node = transformedPlan;
                done = false;
            }
        }
        assert (numIterations < 10000) : "Optimizer reached 10_000 iterations safety guard. This is an indication of a broken rule that matches again and again";
        return node;
    }

    @Nullable
    public static <T> LogicalPlan tryMatchAndApply(Rule<T> rule, LogicalPlan node, Rule.Context ruleContext, OptimizerTracer tracer) {
        Match<T> match = rule.pattern().accept(node, Captures.empty(), ruleContext.resolvePlan());
        if (match.isPresent()) {
            tracer.ruleMatched(rule);
            return rule.apply(match.value(), match.captures(), ruleContext);
        }
        return null;
    }
}

