/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer;

import io.crate.common.StringUtils;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.session.Session;
import java.util.function.UnaryOperator;
import org.elasticsearch.Version;

public interface Rule<T> {
    public Pattern<T> pattern();

    public LogicalPlan apply(T var1, Captures var2, Context var3);

    default public Version requiredVersion() {
        return Version.V_4_0_0;
    }

    default public boolean mandatory() {
        return false;
    }

    default public boolean defaultEnabled() {
        return true;
    }

    default public String sessionSettingName() {
        return Rule.sessionSettingName(this.getClass());
    }

    public static String sessionSettingName(Class<?> rule) {
        return "optimizer_" + StringUtils.camelToSnakeCase((String)rule.getSimpleName());
    }

    public record Context(PlanStats planStats, TransactionContext txnCtx, NodeContext nodeCtx, UnaryOperator<LogicalPlan> resolvePlan, Session.TimeoutToken timeoutToken) {
    }
}

