/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.iterative;

import io.crate.analyze.OrderBy;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryResults;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GroupReference
implements LogicalPlan {
    private final int groupId;
    private final List<Symbol> outputs;
    private final List<RelationName> relationNames;
    private static final String ERROR_MESSAGE = "Operation is not supported in GroupReference, it needs to be resolved to it's referenced LogicalPlan";

    public GroupReference(int groupId, List<Symbol> outputs, Collection<RelationName> relationNames) {
        this.groupId = groupId;
        this.outputs = List.copyOf(outputs);
        this.relationNames = List.copyOf(relationNames);
    }

    public int groupId() {
        return this.groupId;
    }

    @Override
    public List<LogicalPlan> sources() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitGroupReference(this, context);
    }

    @Override
    public List<RelationName> relationNames() {
        return this.relationNames;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier dependencyCarrier, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public String toString() {
        return "GroupReference{" + this.groupId + "}";
    }
}

