/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.sql.tree.JoinType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MoveEquiJoinFilterIntoInnerJoin
implements Rule<Filter> {
    private final Capture<JoinPlan> joinCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(f -> EquiJoinDetector.isEquiJoin(f.query())).with(Patterns.source(), Pattern.typeOf(JoinPlan.class).capturedAs(this.joinCapture).with(j -> j.joinType() == JoinType.INNER));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter equiJoinConditionFilter, Captures captures, Rule.Context context) {
        JoinPlan innerJoin = captures.get(this.joinCapture);
        Symbol query = equiJoinConditionFilter.query();
        HashSet relationNamesInFilter = new HashSet();
        ArrayList<Symbol> newFilterQuery = new ArrayList<Symbol>();
        ArrayList<Symbol> newJoinCondition = new ArrayList<Symbol>();
        newJoinCondition.add(innerJoin.joinCondition());
        for (Map.Entry<Set<RelationName>, Symbol> entries : QuerySplitter.split(query).entrySet()) {
            Symbol value = entries.getValue();
            if (EquiJoinDetector.isEquiJoin(value)) {
                relationNamesInFilter.addAll(entries.getKey());
                newJoinCondition.add(value);
                continue;
            }
            newFilterQuery.add(value);
        }
        HashSet<RelationName> relationNamesInJoin = new HashSet<RelationName>();
        relationNamesInJoin.addAll(innerJoin.lhs().relationNames());
        relationNamesInJoin.addAll(innerJoin.rhs().relationNames());
        if (relationNamesInJoin.containsAll(relationNamesInFilter)) {
            return Filter.create(new JoinPlan(innerJoin.lhs(), innerJoin.rhs(), JoinType.INNER, AndOperator.join(newJoinCondition)), AndOperator.join(newFilterQuery));
        }
        return null;
    }
}

