/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.CorrelatedSubQueries;
import io.crate.planner.operators.CorrelatedJoin;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MoveFilterBeneathCorrelatedJoin
implements Rule<Filter> {
    private final Capture<CorrelatedJoin> joinCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(CorrelatedJoin.class).capturedAs(this.joinCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context ruleContext) {
        CorrelatedJoin join = captures.get(this.joinCapture);
        Map<Set<RelationName>, Symbol> splitQuery = QuerySplitter.split(filter.query());
        assert (join.sources().size() == 1) : "CorrelatedJoin operator must have 1 children, the input plan";
        LogicalPlan inputPlan = join.sources().get(0);
        Symbol inputQuery = splitQuery.remove(new HashSet<RelationName>(inputPlan.relationNames()));
        if (inputQuery == null) {
            return null;
        }
        CorrelatedSubQueries correlatedSubQueries = CorrelatedSubQueries.of(inputQuery);
        if (correlatedSubQueries.remainder().isEmpty()) {
            return null;
        }
        Filter newInputPlan = new Filter(inputPlan, AndOperator.join(correlatedSubQueries.remainder()));
        LogicalPlan newJoin = join.replaceSources(List.of(newInputPlan));
        return new Filter(newJoin, AndOperator.join(splitQuery.values()));
    }
}

