/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.Order;
import io.crate.planner.operators.Union;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import java.util.List;

public final class MoveOrderBeneathUnion
implements Rule<Order> {
    private final Capture<Union> unionCapture = new Capture();
    private final Pattern<Order> pattern = Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(Union.class).capturedAs(this.unionCapture));

    @Override
    public Pattern<Order> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Order order, Captures captures, Rule.Context context) {
        Union union = captures.get(this.unionCapture);
        List<LogicalPlan> unionSources = union.sources();
        assert (unionSources.size() == 2) : "A UNION must have exactly 2 unionSources";
        Order lhsOrder = MoveOrderBeneathUnion.updateSources(order, unionSources.get(0));
        Order rhsOrder = MoveOrderBeneathUnion.updateSources(order, unionSources.get(1));
        return union.replaceSources(List.of(lhsOrder, rhsOrder));
    }

    private static Order updateSources(Order order, LogicalPlan child) {
        List<Symbol> sourceOutputs = order.source().outputs();
        return new Order(child, order.orderBy().map(s -> {
            int idx = sourceOutputs.indexOf(s);
            if (idx < 0) {
                throw new IllegalArgumentException("The ORDER BY expression " + String.valueOf(s) + " must be part of the child union: " + String.valueOf(sourceOutputs));
            }
            return child.outputs().get(idx);
        }));
    }
}

