/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.HashJoin;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;

public class RewriteLeftOuterJoinToHashJoin
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern = Pattern.typeOf(JoinPlan.class).with(j -> j.joinType() == JoinType.LEFT && EquiJoinDetector.isEquiJoin(j.joinCondition()));

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(JoinPlan join, Captures captures, Rule.Context context) {
        if (context.txnCtx().sessionSettings().hashJoinsEnabled()) {
            return new HashJoin(join.lhs(), join.rhs(), join.joinCondition(), join.joinType(), join.lookUpJoin());
        }
        return null;
    }
}

