/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol.rule;

import io.crate.expression.operator.Operators;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.NodeContext;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.symbol.FunctionLookup;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.types.DataType;
import java.util.List;

public class MoveSubscriptOnReferenceCastToLiteralCastInsideOperators
implements Rule<Function> {
    private final Capture<Function> castCapture = new Capture();
    private final Pattern<Function> pattern = Pattern.typeOf(Function.class).with(f -> Operators.COMPARISON_OPERATORS.contains(f.name())).with(f -> f.arguments().get(1).symbolType().isValueOrParameterSymbol()).with(f -> f.arguments().get(0), Pattern.typeOf(Function.class).capturedAs(this.castCapture).with(f -> f.name().equals("_cast")).with(f -> f.arguments().get(0), Pattern.typeOf(Function.class).with(f -> f.name().equals("subscript")).with(f -> f.arguments().get(0).symbolType() == SymbolType.REFERENCE)));

    @Override
    public Pattern<Function> pattern() {
        return this.pattern;
    }

    @Override
    public Symbol apply(Function operator, Captures captures, NodeContext nodeCtx, FunctionLookup functionLookup, Symbol parentNode) {
        Symbol literalOrParam = operator.arguments().get(1);
        Function castFunction = captures.get(this.castCapture);
        Symbol subscript = castFunction.arguments().get(0);
        DataType<?> targetType = subscript.valueType();
        return functionLookup.get(operator.name(), List.of(subscript, literalOrParam.cast(targetType, new CastMode[0])));
    }
}

