/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol.rule;

import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.symbol.FunctionLookup;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.types.StringType;
import java.util.List;
import java.util.Set;

public class SwapCastsInLikeOperators
implements Rule<Function> {
    private final Set<String> LIKE_OPERATORS = Set.of("op_like", "op_ilike");
    private final Capture<Function> castCapture = new Capture();
    private final Pattern<Function> pattern = Pattern.typeOf(Function.class).with(f -> this.LIKE_OPERATORS.contains(f.name())).with(f -> f.arguments().get(1).symbolType().isValueOrParameterSymbol()).with(f -> f.arguments().get(0), Pattern.typeOf(Function.class).capturedAs(this.castCapture).with(f -> f.isCast()).with(f -> {
        Reference ref;
        Symbol patt0$temp = f.arguments().get(0);
        return patt0$temp instanceof Reference && (ref = (Reference)patt0$temp).valueType().id() == 4;
    }));

    @Override
    public Pattern<Function> pattern() {
        return this.pattern;
    }

    @Override
    public Symbol apply(Function likeFunction, Captures captures, NodeContext nodeCtx, FunctionLookup functionLookup, Symbol parentNode) {
        Symbol literalOrParam = likeFunction.arguments().get(1);
        Function castFunction = captures.get(this.castCapture);
        Symbol reference = castFunction.arguments().get(0);
        CastMode castMode = castFunction.castMode();
        assert (castMode != null) : "Pattern matched, function must be a cast";
        Symbol castedLiteral = literalOrParam.cast(StringType.INSTANCE, castMode);
        List<Symbol> newArgs = likeFunction.arguments().size() == 3 ? List.of(reference, castedLiteral, likeFunction.arguments().get(2)) : List.of(reference, castedLiteral);
        return new Function(likeFunction.signature(), newArgs, likeFunction.valueType());
    }
}

