/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.tracer;

import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingOptimizerTracer
implements OptimizerTracer {
    private static final Logger LOGGER = LogManager.getLogger(LoggingOptimizerTracer.class);
    private static final LoggingOptimizerTracer INSTANCE = new LoggingOptimizerTracer();

    private LoggingOptimizerTracer() {
    }

    public static OptimizerTracer getInstance() {
        if (LOGGER.isTraceEnabled()) {
            return INSTANCE;
        }
        return OptimizerTracer.NOOP;
    }

    @Override
    public boolean isActive() {
        return LOGGER.isTraceEnabled();
    }

    @Override
    public void optimizationStarted(LogicalPlan initialPlan, PlanStats planStatsWithMemo) {
        PrintContext printContext = new PrintContext(planStatsWithMemo);
        initialPlan.print(printContext);
        LOGGER.trace("Optimize plan: \n " + String.valueOf(printContext));
    }

    @Override
    public void ruleMatched(Rule<?> rule) {
        LOGGER.trace("Rule " + rule.sessionSettingName() + " matched");
    }

    @Override
    public void ruleApplied(Rule<?> rule, LogicalPlan plan, PlanStats planStats) {
        PrintContext printContext = new PrintContext(planStats);
        plan.print(printContext);
        LOGGER.trace("Rule " + rule.sessionSettingName() + " transformed the logical plan: \n" + String.valueOf(printContext));
    }
}

