/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.data.Row;
import io.crate.protocols.postgres.types.AnyType;
import io.crate.protocols.postgres.types.BigIntType;
import io.crate.protocols.postgres.types.BitType;
import io.crate.protocols.postgres.types.BooleanType;
import io.crate.protocols.postgres.types.CharType;
import io.crate.protocols.postgres.types.CharacterType;
import io.crate.protocols.postgres.types.DateType;
import io.crate.protocols.postgres.types.DoubleType;
import io.crate.protocols.postgres.types.IntegerType;
import io.crate.protocols.postgres.types.IntervalType;
import io.crate.protocols.postgres.types.JsonType;
import io.crate.protocols.postgres.types.NumericType;
import io.crate.protocols.postgres.types.OidType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGFloatVectorType;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.PgOidVectorType;
import io.crate.protocols.postgres.types.PointType;
import io.crate.protocols.postgres.types.RealType;
import io.crate.protocols.postgres.types.RecordType;
import io.crate.protocols.postgres.types.RegclassType;
import io.crate.protocols.postgres.types.RegprocType;
import io.crate.protocols.postgres.types.SmallIntType;
import io.crate.protocols.postgres.types.TimeTZType;
import io.crate.protocols.postgres.types.TimestampType;
import io.crate.protocols.postgres.types.TimestampZType;
import io.crate.protocols.postgres.types.UnknownType;
import io.crate.protocols.postgres.types.VarCharType;
import io.crate.sql.tree.BitString;
import io.crate.types.ArrayType;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.Regclass;
import io.crate.types.Regproc;
import io.crate.types.RowType;
import io.crate.types.TimeTZ;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.locationtech.spatial4j.shape.Point;

public class PGTypes {
    private static final Map<DataType<?>, PGType<?>> CRATE_TO_PG_TYPES = MapBuilder.newLinkedHashMapBuilder().put((Object)DataTypes.BYTE, (Object)CharType.INSTANCE).put((Object)DataTypes.STRING, (Object)VarCharType.INSTANCE).put((Object)DataTypes.CHARACTER, (Object)CharacterType.INSTANCE).put((Object)DataTypes.BOOLEAN, (Object)BooleanType.INSTANCE).put((Object)DataTypes.UNTYPED_OBJECT, (Object)JsonType.INSTANCE).put((Object)RowType.EMPTY, (Object)RecordType.EMPTY_RECORD).put((Object)DataTypes.SHORT, (Object)SmallIntType.INSTANCE).put((Object)DataTypes.INTEGER, (Object)IntegerType.INSTANCE).put((Object)DataTypes.LONG, (Object)BigIntType.INSTANCE).put((Object)DataTypes.FLOAT, (Object)RealType.INSTANCE).put((Object)DataTypes.DOUBLE, (Object)DoubleType.INSTANCE).put((Object)DataTypes.NUMERIC, (Object)NumericType.INSTANCE).put((Object)DataTypes.TIMETZ, (Object)TimeTZType.INSTANCE).put((Object)DataTypes.TIMESTAMPZ, (Object)TimestampZType.INSTANCE).put((Object)DataTypes.TIMESTAMP, (Object)TimestampType.INSTANCE).put((Object)DataTypes.DATE, (Object)DateType.INSTANCE).put((Object)DataTypes.IP, (Object)VarCharType.INSTANCE).put((Object)DataTypes.UNDEFINED, (Object)UnknownType.INSTANCE).put((Object)DataTypes.GEO_SHAPE, (Object)JsonType.INSTANCE).put((Object)io.crate.types.JsonType.INSTANCE, (Object)JsonType.INSTANCE).put((Object)DataTypes.GEO_POINT, (Object)PointType.INSTANCE).put((Object)DataTypes.INTERVAL, (Object)IntervalType.INSTANCE).put((Object)DataTypes.REGPROC, (Object)RegprocType.INSTANCE).put((Object)DataTypes.REGCLASS, (Object)RegclassType.INSTANCE).put((Object)BitStringType.INSTANCE_ONE, (Object)BitType.INSTANCE).put(new ArrayType<Byte>(DataTypes.BYTE), (Object)PGArray.CHAR_ARRAY).put(new ArrayType<Short>(DataTypes.SHORT), (Object)PGArray.INT2_ARRAY).put(new ArrayType<Integer>(DataTypes.INTEGER), (Object)PGArray.INT4_ARRAY).put(new ArrayType<Long>(DataTypes.LONG), (Object)PGArray.INT8_ARRAY).put(new ArrayType<Float>(DataTypes.FLOAT), (Object)PGArray.FLOAT4_ARRAY).put(new ArrayType<Double>(DataTypes.DOUBLE), (Object)PGArray.FLOAT8_ARRAY).put(new ArrayType<BigDecimal>(DataTypes.NUMERIC), (Object)PGArray.NUMERIC_ARRAY).put(new ArrayType<Boolean>(DataTypes.BOOLEAN), (Object)PGArray.BOOL_ARRAY).put(new ArrayType<Long>(DataTypes.TIMESTAMPZ), (Object)PGArray.TIMESTAMPZ_ARRAY).put(new ArrayType<Long>(DataTypes.TIMESTAMP), (Object)PGArray.TIMESTAMP_ARRAY).put(new ArrayType<Long>(DataTypes.DATE), (Object)PGArray.DATE_ARRAY).put(new ArrayType<TimeTZ>(DataTypes.TIMETZ), (Object)PGArray.TIMETZ_ARRAY).put(new ArrayType<String>(DataTypes.STRING), (Object)PGArray.VARCHAR_ARRAY).put(new ArrayType<String>(DataTypes.CHARACTER), (Object)PGArray.CHARACTER_ARRAY).put(new ArrayType<String>(DataTypes.IP), (Object)PGArray.VARCHAR_ARRAY).put(new ArrayType<Map<String, Object>>(DataTypes.UNTYPED_OBJECT), (Object)PGArray.JSON_ARRAY).put(new ArrayType<Object>(DataTypes.UNDEFINED), (Object)PGArray.JSON_ARRAY).put(new ArrayType<Point>(DataTypes.GEO_POINT), (Object)PGArray.POINT_ARRAY).put(new ArrayType<Map<String, Object>>(DataTypes.GEO_SHAPE), (Object)PGArray.JSON_ARRAY).put(new ArrayType<Period>(DataTypes.INTERVAL), (Object)PGArray.INTERVAL_ARRAY).put(new ArrayType<Row>(RowType.EMPTY), (Object)PGArray.EMPTY_RECORD_ARRAY).put(new ArrayType<Regproc>(DataTypes.REGPROC), (Object)PGArray.REGPROC_ARRAY).put(new ArrayType<Regclass>(DataTypes.REGCLASS), (Object)PGArray.REGCLASS_ARRAY).put(new ArrayType<BitString>(BitStringType.INSTANCE_ONE), (Object)PGArray.BIT_ARRAY).put((Object)DataTypes.OIDVECTOR, (Object)PgOidVectorType.INSTANCE).immutableMap();
    private static final IntObjectMap<DataType<?>> PG_TYPES_TO_CRATE_TYPE = new IntObjectHashMap();
    private static final Set<PGType<?>> TYPES;

    public static Iterable<PGType<?>> pgTypes() {
        return TYPES;
    }

    @Nullable
    public static DataType<?> fromOID(int oid) {
        return (DataType)PG_TYPES_TO_CRATE_TYPE.get(oid);
    }

    public static PGType<?> get(DataType<?> type) {
        switch (type.id()) {
            case 100: {
                DataType innerType = ((ArrayType)type).innerType();
                if (innerType.id() == 100) {
                    return JsonType.INSTANCE;
                }
                if (innerType.id() == 12) {
                    return PGArray.JSON_ARRAY;
                }
                if (innerType.id() == 18) {
                    return new PGArray(PGArray.EMPTY_RECORD_ARRAY.oid(), PGTypes.get(innerType));
                }
                PGType<?> pgType = CRATE_TO_PG_TYPES.get(type);
                if (pgType == null) {
                    PGType<?> innerPGType = PGTypes.get(innerType);
                    if (innerPGType == null) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No type mapping from '%s' to pg_type", type.getName()));
                    }
                    return new PGArray(innerPGType.typArray(), innerPGType);
                }
                return pgType;
            }
            case 12: {
                return JsonType.INSTANCE;
            }
            case 18: {
                return new RecordType(Lists.map(((RowType)type).fieldTypes(), PGTypes::get));
            }
            case 4: {
                return VarCharType.INSTANCE;
            }
            case 27: {
                return CharacterType.INSTANCE;
            }
            case 22: {
                return NumericType.INSTANCE;
            }
            case 25: {
                return new BitType(((BitStringType)type).length());
            }
            case 28: {
                return PGFloatVectorType.INSTANCE;
            }
        }
        PGType<?> pgType = CRATE_TO_PG_TYPES.get(type);
        if (pgType == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No type mapping from '%s' to pg_type", type.getName()));
        }
        return pgType;
    }

    static {
        for (Map.Entry<DataType<?>, PGType<?>> e : CRATE_TO_PG_TYPES.entrySet()) {
            int oid = e.getValue().oid();
            if (PG_TYPES_TO_CRATE_TYPE.containsKey(oid)) continue;
            PG_TYPES_TO_CRATE_TYPE.put(oid, e.getKey());
        }
        PG_TYPES_TO_CRATE_TYPE.put(0, (Object)DataTypes.UNDEFINED);
        PG_TYPES_TO_CRATE_TYPE.put(25, (Object)DataTypes.STRING);
        PG_TYPES_TO_CRATE_TYPE.put(PGArray.TEXT_ARRAY.oid(), new ArrayType<String>(DataTypes.STRING));
        PG_TYPES_TO_CRATE_TYPE.put(2276, (Object)DataTypes.UNDEFINED);
        PG_TYPES_TO_CRATE_TYPE.put(PGArray.ANY_ARRAY.oid(), new ArrayType<Object>(DataTypes.UNDEFINED));
        PG_TYPES_TO_CRATE_TYPE.put(19, (Object)DataTypes.STRING);
        PG_TYPES_TO_CRATE_TYPE.put(26, (Object)DataTypes.INTEGER);
        TYPES = new HashSet(CRATE_TO_PG_TYPES.values());
        TYPES.add(AnyType.INSTANCE);
        TYPES.add(PGArray.ANY_ARRAY);
        TYPES.add(VarCharType.NameType.INSTANCE);
        TYPES.add(OidType.INSTANCE);
        TYPES.add(VarCharType.TextType.INSTANCE);
        TYPES.add(PGArray.TEXT_ARRAY);
    }
}

