/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical;

import io.crate.concurrent.FutureActionListener;
import io.crate.exceptions.SubscriptionRestoreException;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.MetadataTracker;
import io.crate.replication.logical.action.PublicationsStateAction;
import io.crate.replication.logical.action.UpdateSubscriptionAction;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TableOrPartition;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusters;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class LogicalReplicationService
implements ClusterStateListener,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger(LogicalReplicationService.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final RemoteClusters remoteClusters;
    private final Client client;
    private final AtomicInteger activeOperations = new AtomicInteger(0);
    private final MetadataUpgradeService metadataUpgradeService;
    private RepositoriesService repositoriesService;
    private RestoreService restoreService;
    private volatile SubscriptionsMetadata currentSubscriptionsMetadata = new SubscriptionsMetadata();
    private volatile PublicationsMetadata currentPublicationsMetadata = new PublicationsMetadata();
    private final MetadataTracker metadataTracker;

    public LogicalReplicationService(Settings settings, IndexScopedSettings indexScopedSettings, ClusterService clusterService, RemoteClusters remoteClusters, ThreadPool threadPool, Client client, AllocationService allocationService, MetadataUpgradeService metadataUpgradeService, LogicalReplicationSettings replicationSettings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.remoteClusters = remoteClusters;
        this.client = client;
        this.metadataUpgradeService = metadataUpgradeService;
        this.metadataTracker = new MetadataTracker(settings, indexScopedSettings, threadPool, this, replicationSettings, remoteClusters::getClient, clusterService, allocationService, metadataUpgradeService);
        clusterService.addListener(this);
    }

    public void repositoriesService(RepositoriesService repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    public void restoreService(RestoreService restoreService) {
        this.restoreService = restoreService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        SubscriptionsMetadata newSubscriptionsMetadata;
        SubscriptionsMetadata prevSubscriptionsMetadata;
        boolean subscriptionsChanged;
        Metadata prevMetadata = event.previousState().metadata();
        Metadata newMetadata = event.state().metadata();
        PublicationsMetadata publicationsMetaData = (PublicationsMetadata)newMetadata.custom("publications");
        if (publicationsMetaData != null) {
            this.currentPublicationsMetadata = publicationsMetaData;
        }
        boolean bl = subscriptionsChanged = !(prevSubscriptionsMetadata = SubscriptionsMetadata.get(prevMetadata)).equals(newSubscriptionsMetadata = SubscriptionsMetadata.get(newMetadata));
        if (subscriptionsChanged) {
            this.currentSubscriptionsMetadata = newSubscriptionsMetadata;
            this.addAndRemoveRepositories(prevSubscriptionsMetadata, newSubscriptionsMetadata);
        }
        if (subscriptionsChanged || event.nodesDelta().masterNodeChanged()) {
            if (event.localNodeMaster()) {
                this.metadataTracker.update(newSubscriptionsMetadata.subscription().keySet());
            } else {
                this.metadataTracker.close();
            }
        }
    }

    private void addAndRemoveRepositories(SubscriptionsMetadata prevSubscriptionsMetadata, SubscriptionsMetadata newSubscriptionsMetadata) {
        String subscriptionName;
        Map<String, Subscription> oldSubscriptions = prevSubscriptionsMetadata.subscription();
        Map<String, Subscription> newSubscriptions = newSubscriptionsMetadata.subscription();
        for (Map.Entry<String, Subscription> entry : newSubscriptions.entrySet()) {
            subscriptionName = entry.getKey();
            boolean subscriptionAdded = oldSubscriptions.get(subscriptionName) == null;
            if (!subscriptionAdded) continue;
            this.addSubscription(subscriptionName, entry.getValue());
        }
        for (Map.Entry<String, Subscription> entry : oldSubscriptions.entrySet()) {
            subscriptionName = entry.getKey();
            boolean subscriptionRemoved = !newSubscriptions.containsKey(subscriptionName);
            if (!subscriptionRemoved) continue;
            this.removeSubscription(subscriptionName);
        }
    }

    private void addSubscription(String subscriptionName, Subscription subscription) {
        assert (this.repositoriesService != null) : "RepositoriesService must be set immediately after LogicalReplicationService construction";
        LOGGER.debug("Adding new logical replication repository for subscription '{}'", (Object)subscriptionName);
        this.repositoriesService.registerInternalRepository("_logical_replication_" + subscriptionName, "logical_replication");
        this.remoteClusters.connect(subscriptionName, subscription.connectionInfo());
    }

    private void removeSubscription(String subscriptionName) {
        assert (this.repositoriesService != null) : "RepositoriesService must be set immediately after LogicalReplicationService construction";
        LOGGER.debug("Removing logical replication repository for dropped subscription '{}'", (Object)subscriptionName);
        this.repositoriesService.unregisterInternalRepository("_logical_replication_" + subscriptionName);
        this.remoteClusters.remove(subscriptionName);
    }

    public Map<String, Subscription> subscriptions() {
        return this.currentSubscriptionsMetadata.subscription();
    }

    public Map<String, Publication> publications() {
        return this.currentPublicationsMetadata.publications();
    }

    @Override
    public void close() throws IOException {
        this.metadataTracker.close();
    }

    public CompletableFuture<PublicationsStateAction.Response> getPublicationState(String subscriptionName, List<String> publications, ConnectionInfo connectionInfo) {
        FutureActionListener<PublicationsStateAction.Response> finalFuture = new FutureActionListener<PublicationsStateAction.Response>();
        BiConsumer<String, Throwable> onError = (message, err) -> {
            CompletableFuture<Boolean> subscriptionStateFuture = this.updateSubscriptionState(subscriptionName, Subscription.State.FAILED, (String)message);
            subscriptionStateFuture.whenComplete((stateResponse, suppressedErr) -> {
                if (suppressedErr != null) {
                    err.addSuppressed((Throwable)suppressedErr);
                }
                finalFuture.completeExceptionally((Throwable)err);
            });
        };
        this.remoteClusters.connect(subscriptionName, connectionInfo).whenComplete((client, err) -> {
            if (err == null) {
                ((CompletableFuture)client.execute(PublicationsStateAction.INSTANCE, new PublicationsStateAction.Request(publications, connectionInfo.settings().get(ConnectionInfo.USERNAME.getKey()))).thenApply(r -> new PublicationsStateAction.Response(this.metadataUpgradeService.upgradeMetadata(r.metadata()), r.unknownPublications()))).whenComplete((d, stateErr) -> {
                    if (stateErr == null) {
                        finalFuture.complete(d);
                    } else {
                        onError.accept("Failed to request the publications state", (Throwable)stateErr);
                    }
                });
            } else {
                onError.accept("Failed to connect to the remote cluster", (Throwable)err);
            }
        });
        return finalFuture;
    }

    public CompletableFuture<Boolean> restore(String subscriptionName, Settings restoreSettings, List<TableOrPartition> tablesToRestore) {
        String publisherClusterRepoName = "_logical_replication_" + subscriptionName;
        RestoreService.RestoreRequest restoreRequest = new RestoreService.RestoreRequest(publisherClusterRepoName, "_latest_", IndicesOptions.LENIENT_EXPAND_OPEN, restoreSettings, MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT, true, false, Strings.EMPTY_ARRAY, false, Strings.EMPTY_ARRAY);
        FutureActionListener restoreListener = new FutureActionListener();
        this.activeOperations.incrementAndGet();
        Set relationNames = tablesToRestore.stream().map(TableOrPartition::table).collect(Collectors.toUnmodifiableSet());
        CompletionStage restoreFuture = ((CompletableFuture)((CompletableFuture)restoreListener.whenComplete((restoreCompletionResponse, throwable) -> this.activeOperations.decrementAndGet())).thenCompose(restoreCompletionResponse -> this.updateSubscriptionState(subscriptionName, relationNames, Subscription.State.RESTORING, null))).thenCompose(bl -> this.afterReplicationStarted(subscriptionName, (RestoreService.RestoreCompletionResponse)restoreListener.join(), relationNames));
        try {
            this.threadPool.executor("snapshot").execute(() -> {
                try {
                    this.restoreService.restoreSnapshot(restoreRequest, tablesToRestore, restoreListener);
                }
                catch (Exception e) {
                    restoreListener.onFailure(e);
                }
            });
        }
        catch (RejectedExecutionException ex) {
            restoreListener.onFailure(ex);
        }
        return restoreFuture;
    }

    private CompletableFuture<Boolean> afterReplicationStarted(String subscriptionName, RestoreService.RestoreCompletionResponse response, Collection<RelationName> relationNames) {
        Function<RestoreInfo, CompletableFuture> onRestoreInfo = restoreInfo -> {
            if (restoreInfo == null || restoreInfo.failedShards() == 0) {
                LOGGER.debug("Restore success, following will start once shards are active");
                return this.updateSubscriptionState(subscriptionName, relationNames, Subscription.State.MONITORING, null);
            }
            assert (restoreInfo.failedShards() > 0) : "Some failed shards are expected";
            LOGGER.error("Failed to restore {}/{} shards", (Object)restoreInfo.failedShards(), (Object)restoreInfo.totalShards());
            String msg = "Error while initial restoring the subscription relations";
            if (restoreInfo.failedShards() != restoreInfo.totalShards()) {
                msg = String.format(Locale.ENGLISH, "Restoring the subscription relations failed partially. Failed to restore %d/%d shards", restoreInfo.failedShards(), restoreInfo.totalShards());
            }
            throw new SubscriptionRestoreException(msg);
        };
        if (response.getRestoreInfo() != null) {
            LOGGER.debug("Restore completed immediately, no shards to wait for using a cluster state listener");
            return onRestoreInfo.apply(response.getRestoreInfo());
        }
        FutureActionListener<RestoreSnapshotResponse> restoreFuture = new FutureActionListener<RestoreSnapshotResponse>();
        this.clusterService.addListener(new RestoreClusterStateListener(this.clusterService, response, restoreFuture));
        return restoreFuture.thenCompose(resp -> (CompletionStage)onRestoreInfo.apply(resp.getRestoreInfo()));
    }

    public CompletableFuture<Boolean> updateSubscriptionState(String subscriptionName, Collection<RelationName> relationNames, Subscription.State newState, @Nullable String failureReason) {
        Subscription oldSubscription = this.subscriptions().get(subscriptionName);
        if (oldSubscription == null) {
            return CompletableFuture.completedFuture(false);
        }
        HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>(oldSubscription.relations());
        for (RelationName relationName : relationNames) {
            relations.put(relationName, new Subscription.RelationState(newState, failureReason));
        }
        return this.updateSubscriptionState(subscriptionName, oldSubscription, relations);
    }

    public CompletableFuture<Boolean> updateSubscriptionState(String subscriptionName, Subscription.State newState, @Nullable String failureReason) {
        Subscription oldSubscription = this.subscriptions().get(subscriptionName);
        if (oldSubscription == null) {
            return CompletableFuture.completedFuture(false);
        }
        HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
        for (Map.Entry<RelationName, Subscription.RelationState> entry : oldSubscription.relations().entrySet()) {
            relations.put(entry.getKey(), new Subscription.RelationState(newState, failureReason));
        }
        return this.updateSubscriptionState(subscriptionName, oldSubscription, relations);
    }

    private CompletableFuture<Boolean> updateSubscriptionState(String subscriptionName, Subscription subscription, Map<RelationName, Subscription.RelationState> relations) {
        Subscription newSubscription = new Subscription(subscription.owner(), subscription.connectionInfo(), subscription.publications(), subscription.settings(), relations);
        UpdateSubscriptionAction.Request request = new UpdateSubscriptionAction.Request(subscriptionName, newSubscription);
        return this.client.execute(UpdateSubscriptionAction.INSTANCE, request).thenApply(AcknowledgedResponse::isAcknowledged);
    }

    @VisibleForTesting
    public boolean isActive() {
        return this.metadataTracker.isActive() || this.activeOperations.get() > 0;
    }
}

