/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.action.DropSubscriptionRequest;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DropSubscriptionAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "internal:crate:replication/logical/subscription/drop";
    public static final DropSubscriptionAction INSTANCE = new DropSubscriptionAction();

    public DropSubscriptionAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<AcknowledgedResponse> getResponseReader() {
        return AcknowledgedResponse::new;
    }

    public static ClusterState removeSubscriptionSetting(Collection<RelationName> relations, ClusterState currentState, Metadata.Builder mdBuilder) {
        Metadata metadata = currentState.metadata();
        for (RelationName relationName : relations) {
            List<IndexMetadata> concreteIndices = metadata.getIndices(relationName, List.of(), false, imd -> imd.getState() == IndexMetadata.State.OPEN ? imd : null);
            for (IndexMetadata indexMetadata : concreteIndices) {
                Settings updatedSettings = DropSubscriptionAction.removeSubscriptionSetting(indexMetadata.getSettings());
                mdBuilder.put(IndexMetadata.builder(indexMetadata).settingsVersion(1L + indexMetadata.getSettingsVersion()).settings(updatedSettings));
            }
            Object t = metadata.getRelation(relationName);
            if (!(t instanceof RelationMetadata.Table)) continue;
            RelationMetadata.Table table = (RelationMetadata.Table)t;
            mdBuilder.setTable(table.name(), table.columns(), DropSubscriptionAction.removeSubscriptionSetting(table.settings()), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), table.indexUUIDs(), table.tableVersion() + 1L);
        }
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    private static Settings removeSubscriptionSetting(Settings settings) {
        Settings.Builder settingsBuilder = Settings.builder().put(settings);
        settingsBuilder.remove(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey());
        return settingsBuilder.build();
    }

    @Singleton
    public static class TransportAction
    extends AbstractDDLTransportAction<DropSubscriptionRequest, AcknowledgedResponse> {
        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
            super(DropSubscriptionAction.NAME, transportService, clusterService, threadPool, DropSubscriptionRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-subscription");
        }

        @Override
        public ClusterStateTaskExecutor<DropSubscriptionRequest> clusterStateTaskExecutor(final DropSubscriptionRequest request) {
            return new DDLClusterStateTaskExecutor<DropSubscriptionRequest>(this){

                @Override
                protected ClusterState execute(ClusterState currentState, DropSubscriptionRequest dropSubscriptionRequest) throws Exception {
                    Metadata currentMetadata = currentState.metadata();
                    Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                    SubscriptionsMetadata oldMetadata = (SubscriptionsMetadata)mdBuilder.getCustom("subscriptions");
                    if (oldMetadata != null && oldMetadata.subscription().containsKey(request.name())) {
                        SubscriptionsMetadata newMetadata = SubscriptionsMetadata.newInstance(oldMetadata);
                        Subscription subscription = newMetadata.subscription().remove(request.name());
                        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                        mdBuilder.putCustom("subscriptions", newMetadata);
                        return DropSubscriptionAction.removeSubscriptionSetting(subscription.relations().keySet(), currentState, mdBuilder);
                    }
                    if (!request.ifExists()) {
                        throw new SubscriptionUnknownException(request.name());
                    }
                    return currentState;
                }
            };
        }

        @Override
        protected ClusterBlockException checkBlock(DropSubscriptionRequest request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }
}

