/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class UpdateSubscriptionAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "internal:crate:replication/logical/subscription/update";
    public static final UpdateSubscriptionAction INSTANCE = new UpdateSubscriptionAction();

    public UpdateSubscriptionAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<AcknowledgedResponse> getResponseReader() {
        return AcknowledgedResponse::new;
    }

    @VisibleForTesting
    static Subscription updateSubscription(Subscription oldSubscription, Subscription newSubscription) {
        HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
        for (Map.Entry<RelationName, Subscription.RelationState> entry : newSubscription.relations().entrySet()) {
            RelationName relationName = entry.getKey();
            relations.put(relationName, Subscription.updateRelationState(oldSubscription.relations().get(relationName), entry.getValue()));
        }
        return new Subscription(newSubscription.owner(), newSubscription.connectionInfo(), newSubscription.publications(), newSubscription.settings(), relations);
    }

    public static ClusterState update(ClusterState clusterState, String subscriptionName, Subscription subscription) {
        Subscription newSubscription;
        Metadata currentMetadata = clusterState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
        SubscriptionsMetadata oldMetadata = (SubscriptionsMetadata)mdBuilder.getCustom("subscriptions");
        if (oldMetadata == null || !oldMetadata.subscription().containsKey(subscriptionName)) {
            throw new SubscriptionUnknownException(subscriptionName);
        }
        Subscription oldSubscription = oldMetadata.subscription().get(subscriptionName);
        if (oldSubscription.equals(newSubscription = UpdateSubscriptionAction.updateSubscription(oldSubscription, subscription))) {
            return clusterState;
        }
        SubscriptionsMetadata newMetadata = SubscriptionsMetadata.newInstance(oldMetadata);
        newMetadata.subscription().put(subscriptionName, newSubscription);
        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("subscriptions", newMetadata);
        return ClusterState.builder(clusterState).metadata(mdBuilder).build();
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String subscriptionName;
        private final Subscription subscription;

        public Request(String subscriptionName, Subscription subscription) {
            this.subscriptionName = subscriptionName;
            this.subscription = subscription;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.subscriptionName = in.readString();
            this.subscription = new Subscription(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.subscriptionName);
            this.subscription.writeTo(out);
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
            super(UpdateSubscriptionAction.NAME, transportService, clusterService, threadPool, Request::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected AcknowledgedResponse read(StreamInput in) throws IOException {
            return new AcknowledgedResponse(in);
        }

        @Override
        protected void masterOperation(final Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
            this.clusterService.submitStateUpdateTask("update-subscription", new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    return UpdateSubscriptionAction.update(currentState, request.subscriptionName, request.subscription);
                }

                @Override
                protected AcknowledgedResponse newResponse(boolean acknowledged) {
                    return new AcknowledgedResponse(acknowledged);
                }
            });
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }
}

