/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata.pgcatalog;

import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.Regclass;
import java.util.stream.Stream;

public class PgSubscriptionRelTable {
    public static final RelationName IDENT = new RelationName("pg_catalog", "pg_subscription_rel");
    public static SystemTable<PgSubscriptionRelRow> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("srsubid", (DataType)DataTypes.INTEGER, PgSubscriptionRelRow::subOid)).add("srrelid", (DataType)DataTypes.REGCLASS, PgSubscriptionRelRow::relOid)).add("srsubstate", (DataType)DataTypes.STRING, PgSubscriptionRelRow::state)).add("srsubstate_reason", (DataType)DataTypes.STRING, PgSubscriptionRelRow::state_reason)).add("srsublsn", (DataType)DataTypes.LONG, ignored -> null)).build();

    public static Iterable<PgSubscriptionRelRow> rows(LogicalReplicationService logicalReplicationService) {
        return () -> {
            Stream s = logicalReplicationService.subscriptions().entrySet().stream().mapMulti((e, c) -> {
                Subscription sub = (Subscription)e.getValue();
                sub.relations().forEach((r, rs) -> c.accept(new PgSubscriptionRelRow(OidHash.subscriptionOid((String)e.getKey(), sub), new Regclass(OidHash.relationOid(OidHash.Type.TABLE, r), r.fqn()), sub.owner(), rs.state().pg_state(), rs.reason())));
            });
            return s.iterator();
        };
    }

    public record PgSubscriptionRelRow(int subOid, Regclass relOid, String owner, String state, String state_reason) {
    }
}

