/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.auth.AccessControl;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.symbol.Symbol;
import io.crate.rest.action.HttpError;
import io.crate.rest.action.RestBulkRowCountReceiver;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentBuilder;

class ResultToXContentBuilder {
    private final XContentBuilder builder;

    private ResultToXContentBuilder(XContentBuilder builder) throws IOException {
        this.builder = builder;
        builder.startObject();
    }

    static ResultToXContentBuilder builder(XContentBuilder builder) throws IOException {
        return new ResultToXContentBuilder(builder);
    }

    ResultToXContentBuilder cols(List<String> fieldNames) throws IOException {
        this.builder.startArray("cols");
        for (String field : fieldNames) {
            this.builder.value(field);
        }
        this.builder.endArray();
        return this;
    }

    ResultToXContentBuilder colTypes(List<? extends Symbol> fields) throws IOException {
        this.builder.startArray("col_types");
        for (Symbol symbol : fields) {
            this.toXContentNestedDataType(this.builder, symbol.valueType());
        }
        this.builder.endArray();
        return this;
    }

    private void toXContentNestedDataType(XContentBuilder builder, DataType<?> dataType) throws IOException {
        if (dataType instanceof ArrayType) {
            builder.startArray();
            builder.value(dataType.id());
            this.toXContentNestedDataType(builder, ((ArrayType)dataType).innerType());
            builder.endArray();
        } else {
            builder.value(dataType.id());
        }
    }

    ResultToXContentBuilder duration(long startTime) throws IOException {
        this.builder.field("duration", (float)((double)(System.nanoTime() - startTime) / 1000000.0));
        return this;
    }

    ResultToXContentBuilder startRows() throws IOException {
        this.builder.startArray("rows");
        return this;
    }

    ResultToXContentBuilder finishRows() throws IOException {
        this.builder.endArray();
        return this;
    }

    ResultToXContentBuilder addRow(Row row, int numCols) throws IOException {
        this.builder.startArray();
        for (int j = 0; j < numCols; ++j) {
            this.builder.value(row.get(j));
        }
        this.builder.endArray();
        return this;
    }

    ResultToXContentBuilder rowCount(long rowCount) throws IOException {
        this.builder.field("rowcount", rowCount);
        return this;
    }

    ResultToXContentBuilder bulkRows(RestBulkRowCountReceiver.Result[] results, AccessControl accessControl) throws IOException {
        this.builder.startArray("results");
        for (RestBulkRowCountReceiver.Result result : results) {
            this.builder.startObject();
            this.builder.field("rowcount", result.rowCount());
            Throwable t = result.error();
            if (t != null) {
                this.builder.startObject("error");
                Throwable throwable = SQLExceptions.prepareForClientTransmission(accessControl, t);
                HttpError httpError = HttpError.fromThrowable(throwable);
                this.builder.field("code", httpError.errorCode());
                this.builder.field("message", Exceptions.userFriendlyMessage((Throwable)throwable));
                this.builder.endObject();
            }
            this.builder.endObject();
        }
        this.builder.endArray();
        return this;
    }

    XContentBuilder build() throws IOException {
        this.builder.endObject();
        return this.builder;
    }

    static final class FIELDS {
        static final String RESULTS = "results";
        static final String COLS = "cols";
        static final String COLUMN_TYPES = "col_types";
        static final String ROWS = "rows";
        static final String ROW_COUNT = "rowcount";
        static final String DURATION = "duration";
        static final String ERROR = "error";
        static final String ERROR_CODE = "code";
        static final String ERROR_MESSAGE = "message";

        FIELDS() {
        }
    }
}

